/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.messaging;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import pt.webdetails.cpf.messaging.JsonGeneratorSerializable;

public class JsonResult
implements JsonGeneratorSerializable {
    public static String OK_FIELD = "status";
    public static String SUCCESS_FIELD = "success";
    public static String OK_STATUS = "ok";
    public static String ERROR_STATUS = "error";
    public static String PAYLOAD_FIELD = "result";
    private boolean status;
    private JsonGeneratorSerializable payload;

    public JsonResult(boolean success, JsonGeneratorSerializable payload) {
        this.status = success;
        this.payload = payload;
    }

    public JsonResult(boolean success, final String contents) {
        this.status = success;
        this.payload = new JsonGeneratorSerializable(){

            @Override
            public void writeToGenerator(JsonGenerator jsonGenerator) throws JsonGenerationException, IOException {
                jsonGenerator.writeString(contents);
            }
        };
    }

    @Override
    public void writeToGenerator(JsonGenerator jsonGenerator) throws JsonGenerationException, IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeBooleanField(SUCCESS_FIELD, this.status);
        jsonGenerator.writeStringField(OK_FIELD, this.status ? OK_STATUS : ERROR_STATUS);
        jsonGenerator.writeFieldName(PAYLOAD_FIELD);
        this.payload.writeToGenerator(jsonGenerator);
        jsonGenerator.writeEndObject();
    }
}

