/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.bean;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import pt.webdetails.cpf.bean.IBeanFactory;

public abstract class AbstractBeanFactory
implements IBeanFactory {
    private static final Log logger = LogFactory.getLog(IBeanFactory.class);
    protected static ConfigurableApplicationContext ctx;

    @Override
    public abstract String getSpringXMLFilename();

    @Override
    public Object getBean(String id) {
        return this.getCtx() != null && this.getCtx().containsBean(id) ? this.getCtx().getBean(id) : null;
    }

    @Override
    public boolean containsBean(String id) {
        return this.getCtx() != null ? this.getCtx().containsBean(id) : false;
    }

    @Override
    public String[] getBeanNamesForType(Class<?> clazz) {
        return this.getCtx().getBeanNamesForType(clazz);
    }

    protected ConfigurableApplicationContext getCtx() {
        if (ctx == null) {
            ctx = this.getSpringBeanFactory(this.getSpringXMLFilename());
        }
        return ctx;
    }

    protected ConfigurableApplicationContext getSpringBeanFactory(String config) {
        this.getLogger().debug((Object)"bean factory init");
        try {
            final ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource(config);
            if (url != null) {
                this.getLogger().debug((Object)("Found spring file @ " + url));
                ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(config){

                    protected void initBeanDefinitionReader(XmlBeanDefinitionReader beanDefinitionReader) {
                        beanDefinitionReader.setBeanClassLoader(cl);
                    }

                    protected void prepareBeanFactory(ConfigurableListableBeanFactory clBeanFactory) {
                        super.prepareBeanFactory(clBeanFactory);
                        clBeanFactory.setBeanClassLoader(cl);
                    }

                    public ClassLoader getClassLoader() {
                        return cl;
                    }
                };
                this.getLogger().debug((Object)"bean factory context");
                return context;
            }
        }
        catch (Exception e) {
            this.getLogger().fatal((Object)("Error loading " + config), (Throwable)e);
        }
        this.getLogger().fatal((Object)("Spring definition file does not exist. There should be a " + config + " file on the classpath "));
        return null;
    }

    protected Log getLogger() {
        return logger;
    }
}

