/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.util;

import java.net.InetSocketAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.ftp4che.exception.UnkownReplyStateException;
import org.ftp4che.reply.Reply;

public class ReplyFormatter {
    public static Logger log = Logger.getLogger((String)ReplyFormatter.class.getName());

    public static String parsePWDReply(Reply pwdReply) throws UnkownReplyStateException {
        List<String> lines = pwdReply.getLines();
        if (lines.size() != 1) {
            throw new UnkownReplyStateException("PWD Reply has to have a size of 1 entry but it has: " + lines.size());
        }
        String line = lines.get(0);
        return line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
    }

    public static Date parseMDTMReply(Reply mdtmReply) throws ParseException {
        List<String> lines = mdtmReply.getLines();
        if (lines.size() != 1) {
            throw new UnkownReplyStateException("MDTM Reply has to have a size of 1 entry but it has: " + lines.size());
        }
        String line = lines.get(0);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        return formatter.parse(line.substring(line.indexOf(32) + 1));
    }

    public static String parseXCRCReply(Reply crcReply) {
        List<String> lines = crcReply.getLines();
        if (lines.size() != 1) {
            throw new UnkownReplyStateException("XCRC Reply has to have a size of 1 entry but it has: " + lines.size());
        }
        String line = lines.get(0);
        return line.substring(line.indexOf(32) + 1);
    }

    public static String parseXMD5Reply(Reply md5Reply) {
        List<String> lines = md5Reply.getLines();
        if (lines.size() != 1) {
            throw new UnkownReplyStateException("XMD5 Reply has to have a size of 1 entry but it has: " + lines.size());
        }
        String line = lines.get(0);
        return line.substring(line.indexOf(32) + 1);
    }

    public static InetSocketAddress parsePASVCommand(Reply pasvReply) throws UnkownReplyStateException {
        List<String> lines = pasvReply.getLines();
        if (lines.size() != 1) {
            throw new UnkownReplyStateException("PASV Reply has to have a size of 1 entry but it has: " + lines.size());
        }
        String line = lines.get(0);
        line = line.substring(line.indexOf(40) + 1, line.lastIndexOf(41));
        String[] host = line.split(",");
        log.debug((Object)("Parsed host:" + host[0] + "." + host[1] + "." + host[2] + "." + host[3] + " port: " + ((Integer.parseInt(host[4]) << 8) + Integer.parseInt(host[5]))));
        return new InetSocketAddress(host[0] + "." + host[1] + "." + host[2] + "." + host[3], (Integer.parseInt(host[4]) << 8) + Integer.parseInt(host[5]));
    }
}

