/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.io;

import java.io.IOException;
import java.io.InputStream;

public class BandwidthControlledInputStream
extends InputStream {
    private int bandwidth = 512;
    private InputStream in;
    private static int SLEEP_TIME = 1000;
    private int bytesRead;
    private long startTime;
    private static final int CHECKS = 4;
    private int lastSum;

    public BandwidthControlledInputStream(InputStream in, int bandwidth) {
        if (bandwidth > this.bandwidth) {
            this.bandwidth = bandwidth / 4;
        }
        this.in = in;
        this.startTime = System.currentTimeMillis();
    }

    public int read() throws IOException {
        int bytes = this.in.read();
        ++this.bytesRead;
        return bytes;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int sum = 0;
        int bytes2read = len - off > this.bandwidth ? this.bandwidth : len - off;
        int newBytes = this.in.read(b, off, bytes2read);
        sum += newBytes;
        if (newBytes == -1) {
            try {
                Thread.sleep(4000 / (this.bandwidth / this.lastSum));
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            return -1;
        }
        this.bytesRead += bytes2read;
        this.sleep();
        this.lastSum = sum;
        return sum;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }

    private void sleep() {
        if (this.bytesRead >= this.bandwidth) {
            long duration = System.currentTimeMillis() - this.startTime;
            if (duration < 250L) {
                try {
                    Thread.sleep(250L - duration);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.startTime = System.currentTimeMillis();
            this.bytesRead = 0;
        }
    }
}

