/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.impl;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.ftp4che.FTPConnection;
import org.ftp4che.commands.Command;
import org.ftp4che.exception.AuthenticationNotSupportedException;
import org.ftp4che.exception.FtpIOException;
import org.ftp4che.exception.FtpWorkflowException;
import org.ftp4che.exception.NotConnectedException;
import org.ftp4che.io.ReplyWorker;
import org.ftp4che.io.SocketProvider;
import org.ftp4che.reply.Reply;
import org.ftp4che.reply.ReplyCode;

public class SecureFTPConnection
extends FTPConnection {
    Logger log = Logger.getLogger((String)SecureFTPConnection.class.getName());

    public void connect() throws NotConnectedException, IOException, AuthenticationNotSupportedException, FtpIOException, FtpWorkflowException {
        this.setConnectionStatusLock(1);
        this.socketProvider = new SocketProvider();
        String hostAndPort = this.getAddress().getHostName() + ":" + this.getAddress().getPort();
        try {
            this.socketProvider.connect(this.getAddress(), this.getProxy(), this.getDownloadBandwidth(), this.getUploadBandwidth());
            this.log.debug((Object)("connected to:" + hostAndPort));
            this.socketProvider.socket().setSoTimeout(this.getTimeout());
            this.socketProvider.socket().setKeepAlive(true);
        }
        catch (IOException ioe) {
            String error = "Error connection to:" + hostAndPort;
            this.log.error((Object)error, (Throwable)ioe);
            throw new NotConnectedException(error);
        }
        if (this.getConnectionType() == 2 || this.getConnectionType() == 5 || this.getConnectionType() == 7 || this.getConnectionType() == 6) {
            this.negotiateAndLogin(null);
        } else {
            ReplyWorker.readReply(this.socketProvider).dumpReply();
            this.negotiateAndLogin(this.getAuthString());
        }
        this.checkFeatures();
        this.setConnectionStatus(1001);
        this.setConnectionStatus(1003);
        this.checkSystem();
        this.setConnectionStatusLock(0);
    }

    private void negotiateAndLogin(String authCommand) throws IOException, AuthenticationNotSupportedException, FtpWorkflowException, FtpIOException {
        Reply reply = null;
        if (authCommand != null) {
            reply = this.sendCommand(new Command(authCommand));
            reply.dumpReply();
        }
        if (authCommand == null || ReplyCode.isPositiveCompletionReply(reply)) {
            try {
                this.socketProvider.setSSLMode(this.getConnectionType());
                this.socketProvider.negotiate(this.getTrustManagers(), this.getKeyManagers());
                if (authCommand == null) {
                    ReplyWorker.readReply(this.socketProvider).dumpReply();
                }
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
            }
            reply = this.sendCommand(new Command("USER", this.getUser()));
            reply.dumpReply();
            reply.validate();
            if (this.getPassword() != null && this.getPassword().length() > 0) {
                reply = this.sendCommand(new Command("PASS", this.getPassword()));
                reply.dumpReply();
                reply.validate();
            }
            if (this.getAccount() != null && this.getAccount().length() > 0) {
                reply = this.sendCommand(new Command("ACCT", this.getAccount()));
                reply.dumpReply();
                reply.validate();
            }
        } else {
            throw new AuthenticationNotSupportedException(authCommand + " not supported by server");
        }
    }

    private String getAuthString() {
        switch (this.getConnectionType()) {
            case 3: {
                return "AUTH SSL";
            }
            case 4: {
                return "AUTH TLS";
            }
        }
        return "SHOULD NOT HAPPEN";
    }
}

