/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che;

import java.net.InetSocketAddress;
import java.util.Properties;
import org.ftp4che.FTPConnection;
import org.ftp4che.exception.ConfigurationException;
import org.ftp4che.impl.NormalFTPConnection;
import org.ftp4che.impl.SecureFTPConnection;
import org.ftp4che.proxy.Proxy;
import org.ftp4che.proxy.Socks4;
import org.ftp4che.proxy.Socks5;

public class FTPConnectionFactory {
    public static FTPConnection getInstance(Properties pt) throws ConfigurationException {
        String connectionTypeName;
        int port = 21;
        int connectionTimeout = 10000;
        int connectionType = 1;
        boolean passive = true;
        int downloadBandwidth = Integer.MAX_VALUE;
        int uploadBandwidth = Integer.MAX_VALUE;
        String proxyType = null;
        String proxyHost = null;
        String proxyUser = null;
        String proxyPass = null;
        int proxyPort = -1;
        int proxyTimeout = -1;
        if (pt.getProperty("connection.port") != null) {
            port = Integer.parseInt(pt.getProperty("connection.port"));
        }
        if (pt.getProperty("connection.timeout") != null) {
            connectionTimeout = Integer.parseInt(pt.getProperty("connection.timeout"));
        }
        if ((connectionTypeName = pt.getProperty("connection.type")) != null) {
            if (connectionTypeName.equalsIgnoreCase("FTP_CONNECTION")) {
                connectionType = 1;
            } else if (connectionTypeName.equalsIgnoreCase("AUTH_TLS_FTP_CONNECTION")) {
                connectionType = 4;
            } else if (connectionTypeName.equalsIgnoreCase("AUTH_SSL_FTP_CONNECTION")) {
                connectionType = 3;
            } else if (connectionTypeName.equalsIgnoreCase("IMPLICIT_SSL_FTP_CONNECTION")) {
                connectionType = 2;
            } else if (connectionTypeName.equalsIgnoreCase("IMPLICIT_TLS_FTP_CONNECTION")) {
                connectionType = 5;
            } else if (connectionTypeName.equalsIgnoreCase("IMPLICIT_TLS_WITH_CRYPTED_DATA_FTP_CONNECTION")) {
                connectionType = 6;
            } else if (connectionTypeName.equalsIgnoreCase("IMPLICIT_SSL_WITH_CRYPTED_DATA_FTP_CONNECTION")) {
                connectionType = 7;
            } else {
                throw new ConfigurationException("Connection method not specified");
            }
        }
        if (pt.getProperty("connection.passive") != null) {
            passive = pt.getProperty("connection.passive").equalsIgnoreCase("true");
        }
        if (pt.getProperty("connection.downloadbw") != null) {
            downloadBandwidth = Integer.parseInt(pt.getProperty("connection.downloadbw"));
        }
        if (pt.getProperty("connection.uploadbw") != null) {
            uploadBandwidth = Integer.parseInt(pt.getProperty("connection.uploadbw"));
        }
        if (pt.getProperty("connection.downloadbw") != null) {
            downloadBandwidth = Integer.parseInt(pt.getProperty("connection.downloadbw"));
        }
        if (pt.getProperty("connection.uploadbw") != null) {
            uploadBandwidth = Integer.parseInt(pt.getProperty("connection.uploadbw"));
        }
        if (pt.getProperty("proxy.type") != null) {
            proxyType = pt.getProperty("proxy.type");
        }
        if (pt.getProperty("proxy.host") != null) {
            proxyHost = pt.getProperty("proxy.host");
        }
        if (pt.getProperty("proxy.port") != null) {
            proxyPort = Integer.parseInt(pt.getProperty("proxy.port"));
        }
        if (pt.getProperty("proxy.user") != null) {
            proxyUser = pt.getProperty("proxy.user");
        }
        if (pt.getProperty("proxy.pass") != null) {
            proxyPass = pt.getProperty("proxy.pass");
        }
        if (pt.getProperty("proxy.timeout") != null) {
            proxyTimeout = Integer.parseInt(pt.getProperty("proxy.timeout"));
        }
        boolean tryResume = false;
        if (pt.getProperty("connection.resume") != null && pt.getProperty("connection.resume").equals("true")) {
            tryResume = true;
        }
        return FTPConnectionFactory.getInstance(pt.getProperty("connection.host"), port, pt.getProperty("user.login"), pt.getProperty("user.password"), pt.getProperty("user.account"), connectionTimeout, connectionType, passive, downloadBandwidth, uploadBandwidth, proxyType, proxyHost, proxyPort, proxyUser, proxyPass, proxyTimeout, tryResume);
    }

    public static FTPConnection getInstance(String host, int port, String user, String password, String account, int timeout, int connectionType, boolean passiveMode) throws ConfigurationException {
        return FTPConnectionFactory.getInstance(host, port, user, password, null, 10000, connectionType, passiveMode, Integer.MAX_VALUE, Integer.MAX_VALUE, null, null, -1, null, null, -1, false);
    }

    public static FTPConnection getInstance(String host, int port, String user, String password, String account, int timeout, int connectionType, boolean passiveMode, int maxDownloadBandwidth, int maxUploadBandwidth, String proxyType, String proxyHost, int proxyPort, String proxyUser, String proxyPass, int proxyTimeout, boolean tryResume) throws ConfigurationException {
        FTPConnection connection = null;
        if (connectionType == 1) {
            connection = new NormalFTPConnection();
        } else if (connectionType == 4 || connectionType == 3 || connectionType == 2 || connectionType == 5 || connectionType == 7 || connectionType == 6) {
            connection = new SecureFTPConnection();
        } else {
            throw new ConfigurationException("No or unknown connection.type in properties");
        }
        connection.setConnectionType(connectionType);
        connection.setAddress(new InetSocketAddress(host, port));
        connection.setUser(user);
        connection.setPassword(password);
        connection.setAccount(account);
        connection.setTimeout(timeout);
        connection.setPassiveMode(passiveMode);
        connection.setDownloadBandwidth(maxDownloadBandwidth);
        connection.setUploadBandwidth(maxUploadBandwidth);
        connection.setTryResume(tryResume);
        Proxy proxy = null;
        if (proxyType != null) {
            if (proxyType.equalsIgnoreCase("SOCKS4")) {
                proxy = new Socks4(proxyHost, proxyPort, proxyTimeout, proxyUser);
            } else if (proxyType.equalsIgnoreCase("SOCKS5")) {
                proxy = new Socks5(proxyHost, proxyPort, proxyUser, proxyPass);
            }
        }
        connection.setProxy(proxy);
        return connection;
    }

    public static FTPConnection getInstance(String host, int port, String user, String password) throws ConfigurationException {
        return FTPConnectionFactory.getInstance(host, port, user, password, null, 10000, 1, false);
    }

    public static FTPConnection getInstance(String host, int port, String user, String password, boolean passive) throws ConfigurationException {
        return FTPConnectionFactory.getInstance(host, port, user, password, null, 10000, 1, passive);
    }

    public static FTPConnection getInstance(String host, int port, String user, String password, int connectionType, boolean passive) throws ConfigurationException {
        return FTPConnectionFactory.getInstance(host, port, user, password, null, 10000, connectionType, passive);
    }

    public static FTPConnection getInstance(String host, String user) throws ConfigurationException {
        return FTPConnectionFactory.getInstance(host, 21, user, "", null, 10000, 1, false);
    }
}

