/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.api.events;

import java.io.Serializable;
import org.pentaho.di.engine.api.events.PDIEvent;
import org.pentaho.di.engine.api.model.LogicalModelElement;
import org.pentaho.di.engine.api.remote.RemoteSource;

public abstract class BaseEvent<S extends LogicalModelElement, D extends Serializable>
implements PDIEvent<S, D> {
    private static final long serialVersionUID = 1976966402442852547L;
    private final S source;
    private final D data;

    public BaseEvent(S source, D data) {
        this.source = source;
        this.data = data;
    }

    @Override
    public S getSource() {
        return this.source;
    }

    @Override
    public D getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseEvent)) {
            return false;
        }
        BaseEvent baseEvent = (BaseEvent)o;
        if (!this.source.getId().equals(baseEvent.source.getId())) {
            return false;
        }
        return this.data.equals(baseEvent.data);
    }

    public int hashCode() {
        int result = 0;
        if (this.source instanceof RemoteSource) {
            result = this.getClass().getName().hashCode();
            result = 31 * result + (((RemoteSource)this.source).getModelType() != null ? ((RemoteSource)this.source).getModelType().toString().hashCode() : 0);
            result = 31 * result + (((RemoteSource)this.source).getId() != null ? ((RemoteSource)this.source).getId().hashCode() : 0);
        } else {
            result = this.source.getId().hashCode();
            result = 31 * result + this.data.hashCode();
        }
        return result;
    }
}

