/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.writer;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DeclaredNamespaces;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;

public class XmlWriterSupport {
    private static final Log LOGGER = LogFactory.getLog(XmlWriterSupport.class);
    public static final int OPEN_TAG_INCREASE = 1;
    public static final int CLOSE_TAG_DECREASE = 2;
    public static final int INDENT_ONLY = 3;
    public static final boolean CLOSE = true;
    public static final boolean OPEN = false;
    private final TagDescription safeTags;
    private final FastStack openTags;
    private final String indentString;
    private boolean lineEmpty;
    private int additionalIndent;
    private boolean alwaysAddNamespace;
    private boolean assumeDefaultNamespace;
    private HashMap impliedNamespaces;
    private boolean writeFinalLinebreak;
    private boolean htmlCompatiblityMode;
    private final String lineSeparator;
    private CharsetEncoder charsetEncoder;

    public XmlWriterSupport() {
        this(new DefaultTagDescription(), "  ");
    }

    public XmlWriterSupport(TagDescription safeTags, String indentString) {
        this(safeTags, indentString, StringUtils.getLineSeparator());
    }

    public XmlWriterSupport(TagDescription safeTags, String indentString, String lineseparator) {
        if (indentString == null) {
            throw new NullPointerException("IndentString must not be null");
        }
        if (safeTags == null) {
            throw new NullPointerException("SafeTags must not be null");
        }
        if (lineseparator == null) {
            throw new NullPointerException("LineSeparator must not be null");
        }
        this.safeTags = safeTags;
        this.openTags = new FastStack();
        this.indentString = indentString;
        this.lineEmpty = true;
        this.writeFinalLinebreak = true;
        this.lineSeparator = lineseparator;
        this.addImpliedNamespace("http://www.w3.org/XML/1998/namespace", "xml");
    }

    public boolean isHtmlCompatiblityMode() {
        return this.htmlCompatiblityMode;
    }

    public void setHtmlCompatiblityMode(boolean htmlCompatiblityMode) {
        this.htmlCompatiblityMode = htmlCompatiblityMode;
    }

    public boolean isAlwaysAddNamespace() {
        return this.alwaysAddNamespace;
    }

    public void setAlwaysAddNamespace(boolean alwaysAddNamespace) {
        this.alwaysAddNamespace = alwaysAddNamespace;
    }

    public int getAdditionalIndent() {
        return this.additionalIndent;
    }

    public void setAdditionalIndent(int additionalIndent) {
        this.additionalIndent = additionalIndent;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void writeXmlDeclaration(Writer writer, String encoding) throws IOException {
        if (encoding == null) {
            writer.write("<?xml version=\"1.0\"?>");
            writer.write(this.getLineSeparator());
            return;
        }
        writer.write("<?xml version=\"1.0\" encoding=\"");
        writer.write(encoding);
        writer.write("\"?>");
        writer.write(this.getLineSeparator());
        this.setEncoding(encoding);
    }

    public void setEncoding(String encoding) {
        Charset charset = Charset.forName(encoding);
        this.charsetEncoder = charset.newEncoder();
    }

    public void writeTag(Writer w, String namespaceUri, String name) throws IOException {
        this.writeTag(w, namespaceUri, name, null, false);
    }

    public void writeCloseTag(Writer w) throws IOException {
        this.indentForClose(w);
        ElementLevel level = (ElementLevel)this.openTags.pop();
        this.setLineEmpty(false);
        w.write("</");
        String prefix = level.getPrefix();
        if (prefix != null) {
            w.write(prefix);
            w.write(":");
            w.write(level.getTagName());
        } else {
            w.write(level.getTagName());
        }
        w.write(">");
        this.doEndOfLine(w);
    }

    public void writeNewLine(Writer writer) throws IOException {
        if (!this.isLineEmpty()) {
            writer.write(this.lineSeparator);
            this.setLineEmpty(true);
        }
    }

    public boolean isLineEmpty() {
        return this.lineEmpty;
    }

    public void setLineEmpty(boolean lineEmpty) {
        this.lineEmpty = lineEmpty;
    }

    public void writeTag(Writer w, String namespace, String name, String attributeName, String attributeValue, boolean close) throws IOException {
        if (attributeName != null) {
            AttributeList attr = new AttributeList();
            attr.setAttribute(namespace, attributeName, attributeValue);
            this.writeTag(w, namespace, name, attr, close);
        } else {
            this.writeTag(w, namespace, name, null, close);
        }
    }

    public void addImpliedNamespace(String uri, String prefix) {
        if (!this.openTags.isEmpty()) {
            throw new IllegalStateException("Cannot modify the implied namespaces in the middle of the processing");
        }
        if (prefix == null) {
            if (this.impliedNamespaces == null) {
                return;
            }
            this.impliedNamespaces.remove(uri);
        } else {
            if (this.impliedNamespaces == null) {
                this.impliedNamespaces = new HashMap();
            }
            this.impliedNamespaces.put(uri, prefix);
        }
    }

    public void copyNamespaces(XmlWriterSupport writerSupport) {
        if (!this.openTags.isEmpty()) {
            throw new IllegalStateException("Cannot modify the implied namespaces in the middle of the processing");
        }
        if (this.impliedNamespaces == null) {
            this.impliedNamespaces = new HashMap();
        }
        if (!writerSupport.openTags.isEmpty()) {
            ElementLevel parent = (ElementLevel)writerSupport.openTags.peek();
            this.impliedNamespaces.putAll(parent.getNamespaces().getNamespaces());
        }
        if (writerSupport.impliedNamespaces != null) {
            this.impliedNamespaces.putAll(writerSupport.impliedNamespaces);
        }
    }

    public boolean isNamespaceDefined(String uri) {
        if (this.impliedNamespaces != null && this.impliedNamespaces.containsKey(uri)) {
            return true;
        }
        if (this.openTags.isEmpty()) {
            return false;
        }
        ElementLevel parent = (ElementLevel)this.openTags.peek();
        return parent.getNamespaces().isNamespaceDefined(uri);
    }

    public boolean isNamespacePrefixDefined(String prefix) {
        if (this.impliedNamespaces != null && this.impliedNamespaces.containsValue(prefix)) {
            return true;
        }
        if (this.openTags.isEmpty()) {
            return false;
        }
        ElementLevel parent = (ElementLevel)this.openTags.peek();
        return parent.getNamespaces().isPrefixDefined(prefix);
    }

    public Properties getNamespaces() {
        Properties namespaces = new Properties();
        if (this.openTags.isEmpty()) {
            if (this.impliedNamespaces != null) {
                namespaces.putAll((Map<?, ?>)this.impliedNamespaces);
            }
            return namespaces;
        }
        ElementLevel parent = (ElementLevel)this.openTags.peek();
        namespaces.putAll((Map<?, ?>)parent.getNamespaces().getNamespaces());
        return namespaces;
    }

    protected DeclaredNamespaces computeNamespaces() {
        if (this.openTags.isEmpty()) {
            DeclaredNamespaces namespaces = new DeclaredNamespaces();
            if (this.impliedNamespaces != null) {
                return namespaces.add(this.impliedNamespaces);
            }
            return namespaces;
        }
        ElementLevel parent = (ElementLevel)this.openTags.peek();
        return parent.getNamespaces();
    }

    public void writeTag(Writer w, String namespaceUri, String name, AttributeList attributes, boolean close) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        this.indent(w);
        this.setLineEmpty(false);
        DeclaredNamespaces namespaces = this.computeNamespaces();
        if (attributes != null) {
            namespaces = namespaces.add(attributes);
        }
        w.write("<");
        if (namespaceUri == null) {
            w.write(name);
            this.openTags.push((Object)new ElementLevel(name, namespaces));
        } else {
            String nsPrefix = namespaces.getPrefix(namespaceUri);
            if (nsPrefix == null) {
                throw new IllegalArgumentException("Namespace " + namespaceUri + " is not defined.");
            }
            if ("".equals(nsPrefix)) {
                w.write(name);
                this.openTags.push((Object)new ElementLevel(namespaceUri, null, name, namespaces));
            } else {
                w.write(nsPrefix);
                w.write(":");
                w.write(name);
                this.openTags.push((Object)new ElementLevel(namespaceUri, nsPrefix, name, namespaces));
            }
        }
        if (attributes != null) {
            AttributeList.AttributeEntry[] entries;
            for (AttributeList.AttributeEntry entry : entries = attributes.toArray()) {
                w.write(" ");
                this.buildAttributeName(entry, namespaces, w);
                w.write("=\"");
                this.writeTextNormalized(w, entry.getValue(), true);
                w.write("\"");
            }
        }
        if (close) {
            if (this.isHtmlCompatiblityMode()) {
                w.write(" />");
            } else {
                w.write("/>");
            }
            this.openTags.pop();
            this.doEndOfLine(w);
        } else {
            w.write(">");
            this.doEndOfLine(w);
        }
    }

    private void doEndOfLine(Writer w) throws IOException {
        if (this.openTags.isEmpty()) {
            if (this.isWriteFinalLinebreak()) {
                this.writeNewLine(w);
            }
        } else {
            ElementLevel level = (ElementLevel)this.openTags.peek();
            if (!this.getTagDescription().hasCData(level.getNamespace(), level.getTagName())) {
                this.writeNewLine(w);
            }
        }
    }

    private void buildAttributeName(AttributeList.AttributeEntry entry, DeclaredNamespaces namespaces, Writer writer) throws IOException {
        ElementLevel currentElement = (ElementLevel)this.openTags.peek();
        String name = entry.getName();
        String namespaceUri = entry.getNamespace();
        if (!this.isAlwaysAddNamespace() && ObjectUtilities.equal((Object)currentElement.getNamespace(), (Object)namespaceUri)) {
            writer.write(name);
            return;
        }
        if (namespaceUri == null) {
            writer.write(name);
            return;
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceUri)) {
            if ("".equals(name)) {
                writer.write("xmlns");
                return;
            }
            writer.write("xmlns:");
            writer.write(name);
            return;
        }
        String namespacePrefix = namespaces.getPrefix(namespaceUri);
        if (namespacePrefix != null && !"".equals(namespacePrefix)) {
            writer.write(namespacePrefix);
            writer.write(58);
            writer.write(name);
        } else {
            writer.write(name);
        }
    }

    public String normalizeLocal(String s, boolean transformNewLine) throws IOException {
        return XmlWriterSupport.normalize(s, transformNewLine);
    }

    public void writeTextNormalized(Writer writer, String s, boolean transformNewLine) throws IOException {
        XmlWriterSupport.writeTextNormalized(writer, s, this.charsetEncoder, transformNewLine);
    }

    private static void writeTextNormalized(Writer writer, String s, CharsetEncoder encoder, boolean transformNewLine) throws IOException {
        int cp;
        if (s == null) {
            return;
        }
        StringBuilder strB = new StringBuilder(s.length());
        block10: for (int offset = 0; offset < s.length(); offset += Character.charCount(cp)) {
            cp = s.codePointAt(offset);
            switch (cp) {
                case 9: {
                    strB.appendCodePoint(cp);
                    continue block10;
                }
                case 10: {
                    if (transformNewLine) {
                        strB.append("&#10;");
                        continue block10;
                    }
                    strB.appendCodePoint(cp);
                    continue block10;
                }
                case 13: {
                    if (transformNewLine) {
                        strB.append("&#13;");
                        continue block10;
                    }
                    strB.appendCodePoint(cp);
                    continue block10;
                }
                case 60: {
                    strB.append("&lt;");
                    continue block10;
                }
                case 62: {
                    strB.append("&gt;");
                    continue block10;
                }
                case 34: {
                    strB.append("&quot;");
                    continue block10;
                }
                case 38: {
                    strB.append("&amp;");
                    continue block10;
                }
                case 39: {
                    strB.append("&apos;");
                    continue block10;
                }
                default: {
                    if (cp < 32) continue block10;
                    String cpStr = new String(new int[]{cp}, 0, 1);
                    if (encoder != null && !encoder.canEncode(cpStr)) {
                        strB.append("&#x" + Integer.toHexString(cp));
                        continue block10;
                    }
                    strB.appendCodePoint(cp);
                }
            }
        }
        writer.write(strB.toString());
    }

    public static String normalize(String s, boolean transformNewLine) {
        if (s == null) {
            return "";
        }
        StringWriter writer = new StringWriter(s.length());
        try {
            XmlWriterSupport.writeTextNormalized(writer, s, null, transformNewLine);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            return s;
        }
        return writer.toString();
    }

    public void indent(Writer writer) throws IOException {
        if (this.openTags.isEmpty()) {
            for (int i = 0; i < this.additionalIndent; ++i) {
                writer.write(this.indentString);
            }
            return;
        }
        ElementLevel level = (ElementLevel)this.openTags.peek();
        if (!this.getTagDescription().hasCData(level.getNamespace(), level.getTagName())) {
            int i;
            this.doEndOfLine(writer);
            for (i = 0; i < this.openTags.size(); ++i) {
                writer.write(this.indentString);
            }
            for (i = 0; i < this.additionalIndent; ++i) {
                writer.write(this.indentString);
            }
        }
    }

    public void indentForClose(Writer writer) throws IOException {
        if (this.openTags.isEmpty()) {
            for (int i = 0; i < this.additionalIndent; ++i) {
                writer.write(this.indentString);
            }
            return;
        }
        ElementLevel level = (ElementLevel)this.openTags.peek();
        if (!this.getTagDescription().hasCData(level.getNamespace(), level.getTagName())) {
            int i;
            this.doEndOfLine(writer);
            for (i = 1; i < this.openTags.size(); ++i) {
                writer.write(this.indentString);
            }
            for (i = 0; i < this.additionalIndent; ++i) {
                writer.write(this.indentString);
            }
        }
    }

    public TagDescription getTagDescription() {
        return this.safeTags;
    }

    public void writeComment(Writer writer, String comment) throws IOException {
        if (!this.openTags.isEmpty()) {
            ElementLevel level = (ElementLevel)this.openTags.peek();
            if (!this.getTagDescription().hasCData(level.getNamespace(), level.getTagName())) {
                this.indent(writer);
            }
        }
        this.setLineEmpty(false);
        writer.write("<!-- ");
        this.writeTextNormalized(writer, comment, false);
        writer.write(" -->");
        this.doEndOfLine(writer);
    }

    public boolean isAssumeDefaultNamespace() {
        return this.assumeDefaultNamespace;
    }

    public void setAssumeDefaultNamespace(boolean assumeDefaultNamespace) {
        this.assumeDefaultNamespace = assumeDefaultNamespace;
    }

    public int getCurrentIndentLevel() {
        return this.additionalIndent + this.openTags.size();
    }

    public void setWriteFinalLinebreak(boolean writeFinalLinebreak) {
        this.writeFinalLinebreak = writeFinalLinebreak;
    }

    public boolean isWriteFinalLinebreak() {
        return this.writeFinalLinebreak;
    }

    private static class ElementLevel {
        private String namespace;
        private String prefix;
        private final String tagName;
        private final DeclaredNamespaces namespaces;

        protected ElementLevel(String namespace, String prefix, String tagName, DeclaredNamespaces namespaces) {
            if (tagName == null) {
                throw new NullPointerException();
            }
            if (namespaces == null) {
                throw new NullPointerException();
            }
            this.prefix = prefix;
            this.namespace = namespace;
            this.tagName = tagName;
            this.namespaces = namespaces;
        }

        protected ElementLevel(String tagName, DeclaredNamespaces namespaces) {
            if (tagName == null) {
                throw new NullPointerException();
            }
            if (namespaces == null) {
                throw new NullPointerException();
            }
            this.namespaces = namespaces;
            this.tagName = tagName;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getTagName() {
            return this.tagName;
        }

        public DeclaredNamespaces getNamespaces() {
            return this.namespaces;
        }
    }
}

