/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class AttributeMap<T>
implements Serializable,
Cloneable {
    private static final String[] EMPTY_NAMESPACES = new String[0];
    private static final long serialVersionUID = -7442871030874215436L;
    private LinkedHashMap<DualKey, T> content;

    public AttributeMap() {
    }

    public AttributeMap(AttributeMap copy) {
        if (copy == null) {
            return;
        }
        if (copy.content != null) {
            this.content = (LinkedHashMap)copy.content.clone();
        }
    }

    public AttributeMap<T> clone() {
        try {
            AttributeMap map = (AttributeMap)super.clone();
            if (this.content != null) {
                map.content = (LinkedHashMap)this.content.clone();
            }
            return map;
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("Cannot happen: Clone not supported exception");
        }
    }

    public T setAttribute(String namespace, String attribute, T value) {
        if (namespace == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (attribute == null) {
            throw new NullPointerException("Attribute name must not be null");
        }
        if (this.content == null) {
            this.content = new LinkedHashMap();
        }
        if (value != null) {
            return this.content.put(new DualKey(namespace, attribute), value);
        }
        return (T)this.content.remove(new DualKey(namespace, attribute));
    }

    public T getAttribute(String namespace, String attribute) {
        if (namespace == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (attribute == null) {
            throw new NullPointerException("Attribute name must not be null");
        }
        if (this.content == null) {
            return null;
        }
        return this.content.get(new DualKey(namespace, attribute));
    }

    public T getFirstAttribute(String attribute) {
        if (attribute == null) {
            throw new NullPointerException("Attribute name must not be null");
        }
        if (this.content != null) {
            for (Map.Entry<DualKey, T> entry : this.content.entrySet()) {
                if (!attribute.equals(entry.getKey().name)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public Map<String, T> getAttributes(String namespace) {
        if (namespace == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (this.content == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, T> entries = new LinkedHashMap<String, T>();
        for (Map.Entry<DualKey, T> entry : this.content.entrySet()) {
            DualKey key = entry.getKey();
            if (!namespace.equals(key.namespace)) continue;
            entries.put(key.name, entry.getValue());
        }
        return Collections.unmodifiableMap(entries);
    }

    public String[] getNames(String namespace) {
        if (namespace == null) {
            throw new NullPointerException("Attribute namespace must not be null");
        }
        if (this.content == null) {
            return EMPTY_NAMESPACES;
        }
        ArrayList<String> entries = new ArrayList<String>();
        for (Map.Entry<DualKey, T> entry : this.content.entrySet()) {
            DualKey key = entry.getKey();
            if (!namespace.equals(key.namespace)) continue;
            entries.add(key.name);
        }
        return entries.toArray(new String[entries.size()]);
    }

    public Set<DualKey> keySet() {
        if (this.content == null) {
            return Collections.emptySet();
        }
        return this.content.keySet();
    }

    public String[] getNameSpaces() {
        if (this.content == null) {
            return EMPTY_NAMESPACES;
        }
        LinkedHashSet<String> entries = new LinkedHashSet<String>();
        for (Map.Entry<DualKey, T> entry : this.content.entrySet()) {
            entries.add(entry.getKey().namespace);
        }
        return entries.toArray(new String[entries.size()]);
    }

    public void putAll(AttributeMap<T> attributeMap) {
        if (attributeMap.content == null) {
            return;
        }
        if (this.content == null) {
            this.content = (LinkedHashMap)attributeMap.content.clone();
        } else {
            this.content.putAll(attributeMap.content);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeMap that = (AttributeMap)o;
        return !(this.content != null ? !this.content.equals(that.content) : that.content != null);
    }

    public int hashCode() {
        if (this.content != null) {
            return this.content.hashCode();
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AttributeMap");
        sb.append("{content=").append(this.content);
        sb.append('}');
        return sb.toString();
    }

    public void clear() {
        if (this.content != null) {
            this.content.clear();
        }
    }

    public static class DualKey
    implements Serializable {
        public final String namespace;
        public final String name;

        private DualKey(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DualKey dualKey = (DualKey)o;
            if (!this.name.equals(dualKey.name)) {
                return false;
            }
            return this.namespace.equals(dualKey.namespace);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.namespace.hashCode();
            return result;
        }

        public String toString() {
            return String.format("DualKey(%s, %s)", this.namespace, this.name);
        }
    }
}

