/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.util.Home;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class MessageIDGenerator {
    private static MessageIDGenerator messageIdGenerator;
    private long id;
    private FileWriter fileW;
    private static final String idFile;

    static {
        idFile = String.valueOf(Home.getHomeDirectory().getAbsolutePath()) + "/id_file";
    }

    private MessageIDGenerator() throws IOException {
        try {
            File extFile = new File(idFile);
            if (extFile.createNewFile()) {
                this.id = 0L;
            } else {
                FileReader fileR = new FileReader(idFile);
                char[] charArray = new char[100];
                int e = fileR.read(charArray);
                if (e <= 0) {
                    this.id = 0L;
                } else {
                    String idStr = String.valueOf(charArray);
                    String idStrTrim = idStr.trim();
                    this.id = Long.parseLong(idStrTrim);
                }
                fileR.close();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
    }

    public static synchronized MessageIDGenerator getInstance() throws IOException {
        if (messageIdGenerator == null) {
            messageIdGenerator = new MessageIDGenerator();
        }
        return messageIdGenerator;
    }

    public synchronized String getNewID() throws IOException {
        ++this.id;
        this.fileW = new FileWriter(idFile, false);
        String idStr = String.valueOf(this.id);
        this.fileW.write(idStr);
        this.fileW.flush();
        this.fileW.close();
        return String.valueOf(this.id);
    }
}

