/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.validation.PrimitiveTypeRule;
import ca.uhn.hl7v2.validation.ValidationContext;

public abstract class AbstractPrimitive
extends AbstractType
implements Primitive {
    private String myValue;

    public AbstractPrimitive(Message message) {
        super(message);
    }

    public String toString() {
        return this.getValue();
    }

    public String getValue() {
        return this.myValue;
    }

    public void setValue(String theValue) throws DataTypeException {
        Message message = this.getMessage();
        if (message != null) {
            ValidationContext context = message.getValidationContext();
            String version = message.getVersion();
            if (context != null) {
                PrimitiveTypeRule[] rules = context.getPrimitiveRules(version, this.getName(), this);
                int i = 0;
                while (i < rules.length) {
                    if (!rules[i].test(theValue = rules[i].correct(theValue))) {
                        throw new DataTypeException("Failed validation rule for value \"" + theValue + "\": " + rules[i].getDescription());
                    }
                    ++i;
                }
            }
        }
        this.myValue = theValue;
    }

    public String encode() throws HL7Exception {
        return this.getValue();
    }

    public void parse(String string) throws HL7Exception {
        this.clear();
        this.setValue(string);
    }

    public void clear() {
        super.clear();
        this.myValue = null;
    }
}

