/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.georss;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.georss.GeoRSSModule;
import com.sun.syndication.feed.module.georss.geometries.AbstractGeometry;
import com.sun.syndication.feed.module.georss.geometries.AbstractRing;
import com.sun.syndication.feed.module.georss.geometries.Envelope;
import com.sun.syndication.feed.module.georss.geometries.LineString;
import com.sun.syndication.feed.module.georss.geometries.LinearRing;
import com.sun.syndication.feed.module.georss.geometries.Point;
import com.sun.syndication.feed.module.georss.geometries.Polygon;
import com.sun.syndication.feed.module.georss.geometries.Position;
import com.sun.syndication.feed.module.georss.geometries.PositionList;
import com.sun.syndication.io.ModuleGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class SimpleGenerator
implements ModuleGenerator {
    private static final Set NAMESPACES;

    private String posListToString(PositionList positionList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < positionList.size(); ++i) {
            stringBuffer.append(positionList.getLatitude(i)).append(" ").append(positionList.getLongitude(i)).append(" ");
        }
        return stringBuffer.toString();
    }

    public String getNamespaceUri() {
        return "http://www.georss.org/georss";
    }

    public Set getNamespaces() {
        return NAMESPACES;
    }

    public void generate(Module module, Element element) {
        Element element2 = element;
        while (element2.getParent() != null && element2.getParent() instanceof Element) {
            element2 = (Element)element.getParent();
        }
        element2.addNamespaceDeclaration(GeoRSSModule.SIMPLE_NS);
        GeoRSSModule geoRSSModule = (GeoRSSModule)module;
        AbstractGeometry abstractGeometry = geoRSSModule.getGeometry();
        if (abstractGeometry instanceof Point) {
            Position position = ((Point)abstractGeometry).getPosition();
            Element element3 = new Element("point", GeoRSSModule.SIMPLE_NS);
            element3.addContent(position.getLatitude() + " " + position.getLongitude());
            element.addContent((Content)element3);
        } else if (abstractGeometry instanceof LineString) {
            PositionList positionList = ((LineString)abstractGeometry).getPositionList();
            Element element4 = new Element("line", GeoRSSModule.SIMPLE_NS);
            element4.addContent(this.posListToString(positionList));
            element.addContent((Content)element4);
        } else if (abstractGeometry instanceof Polygon) {
            AbstractRing abstractRing = ((Polygon)abstractGeometry).getExterior();
            if (abstractRing instanceof LinearRing) {
                PositionList positionList = ((LinearRing)abstractRing).getPositionList();
                Element element5 = new Element("polygon", GeoRSSModule.SIMPLE_NS);
                element5.addContent(this.posListToString(positionList));
                element.addContent((Content)element5);
            } else {
                System.err.println("GeoRSS simple format can't handle rings of type: " + abstractRing.getClass().getName());
            }
            if (((Polygon)abstractGeometry).getInterior() != null || !((Polygon)abstractGeometry).getInterior().isEmpty()) {
                System.err.println("GeoRSS simple format can't handle interior rings (ignored)");
            }
        } else if (abstractGeometry instanceof Envelope) {
            Envelope envelope = (Envelope)abstractGeometry;
            Element element6 = new Element("box", GeoRSSModule.SIMPLE_NS);
            element6.addContent(envelope.getMinLatitude() + " " + envelope.getMinLongitude() + " " + envelope.getMaxLatitude() + " " + envelope.getMaxLongitude());
            element.addContent((Content)element6);
        } else {
            System.err.println("GeoRSS simple format can't handle geometries of type: " + abstractGeometry.getClass().getName());
        }
    }

    static {
        HashSet<Namespace> hashSet = new HashSet<Namespace>();
        hashSet.add(GeoRSSModule.SIMPLE_NS);
        NAMESPACES = Collections.unmodifiableSet(hashSet);
    }
}

