/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.values;

import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSType;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class CSSNumericValue
implements CSSValue {
    private static final long serialVersionUID = 3906005900395358108L;
    public static final CSSNumericValue ZERO_LENGTH = CSSNumericValue.createValue(CSSNumericType.PT, 0.0);
    private double value;
    private CSSNumericType type;

    protected CSSNumericValue(CSSNumericType type, double value) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public CSSType getType() {
        return this.type;
    }

    public CSSNumericType getNumericType() {
        return this.type;
    }

    @Override
    public String getCSSText() {
        String typeText = this.type.getType();
        double value = this.getValue();
        if (typeText.length() == 0) {
            if (Math.floor(value) == value) {
                return String.valueOf((long)value);
            }
            return String.valueOf(value);
        }
        if (Math.floor(value) == value) {
            return String.valueOf((long)value) + typeText;
        }
        return value + typeText;
    }

    public String toString() {
        return this.getCSSText();
    }

    public static CSSNumericValue createPtValue(double value) {
        return new CSSNumericValue(CSSNumericType.PT, value);
    }

    public static CSSNumericValue createValue(CSSNumericType type, double value) {
        return new CSSNumericValue(type, value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CSSNumericValue)) {
            return false;
        }
        CSSNumericValue that = (CSSNumericValue)obj;
        if (this.value != that.value) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.type, (Object)that.type);
    }
}

