/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.percentages.fonts;

import org.pentaho.reporting.libraries.css.LibCssBoot;
import org.pentaho.reporting.libraries.css.StyleSheetUtility;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.dom.OutputProcessorFeature;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class FontSizeResolveHandler
implements ResolveHandler {
    private double baseFontSize = this.parseDouble("org.jfree.layouting.defaults.FontSize", 12.0);
    private static final StyleKey[] EMPTY_KEYS = new StyleKey[0];

    private double parseDouble(String configKey, double defaultValue) {
        LibCssBoot boot = LibCssBoot.getInstance();
        String value = boot.getGlobalConfig().getConfigProperty(configKey);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    @Override
    public StyleKey[] getRequiredStyles() {
        return EMPTY_KEYS;
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        CSSValue value = layoutContext.getValue(key);
        LayoutElement parent = currentNode.getParentLayoutElement();
        if (!(value instanceof CSSNumericValue)) {
            if (parent == null) {
                layoutContext.setValue(key, CSSNumericValue.createValue(CSSNumericType.PT, this.baseFontSize));
            } else {
                LayoutStyle parentContext = parent.getLayoutStyle();
                layoutContext.setValue(key, parentContext.getValue(key));
            }
            return;
        }
        int resolution = (int)process.getOutputMetaData().getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION);
        layoutContext.setValue(key, StyleSheetUtility.convertFontSize(value, resolution, currentNode));
    }
}

