/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed.content;

import java.net.URL;
import java.util.ArrayList;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.content.ContentStyleKeys;
import org.pentaho.reporting.libraries.css.keys.content.ContentValues;
import org.pentaho.reporting.libraries.css.keys.internal.InternalStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.FunctionEvaluationException;
import org.pentaho.reporting.libraries.css.resolver.function.FunctionFactory;
import org.pentaho.reporting.libraries.css.resolver.function.StyleValueFunction;
import org.pentaho.reporting.libraries.css.resolver.tokens.ContentToken;
import org.pentaho.reporting.libraries.css.resolver.tokens.statics.ExternalContentToken;
import org.pentaho.reporting.libraries.css.resolver.tokens.statics.ResourceContentToken;
import org.pentaho.reporting.libraries.css.resolver.tokens.statics.StaticTextToken;
import org.pentaho.reporting.libraries.css.resolver.values.ContentSpecification;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSAttrFunction;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSFunctionValue;
import org.pentaho.reporting.libraries.css.values.CSSRawValue;
import org.pentaho.reporting.libraries.css.values.CSSResourceValue;
import org.pentaho.reporting.libraries.css.values.CSSStringType;
import org.pentaho.reporting.libraries.css.values.CSSStringValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValueList;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class XAlternateTextResolveHandler
implements ResolveHandler {
    private static final ContentToken[] DEFAULT_CONTENT = new ContentToken[0];

    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{ContentStyleKeys.COUNTER_RESET, ContentStyleKeys.COUNTER_INCREMENT, ContentStyleKeys.QUOTES, ContentStyleKeys.STRING_DEFINE};
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement element, StyleKey key) {
        LayoutStyle layoutContext = element.getLayoutStyle();
        ContentSpecification contentSpecification = (ContentSpecification)layoutContext.getValue(InternalStyleKeys.INTERNAL_CONTENT);
        CSSValue value = layoutContext.getValue(key);
        if (value instanceof CSSConstant && ContentValues.NONE.equals(value)) {
            contentSpecification.setStrings(DEFAULT_CONTENT);
            return;
        }
        contentSpecification.setStrings(DEFAULT_CONTENT);
        if (value instanceof CSSAttrFunction) {
            ContentToken token = this.evaluateFunction((CSSFunctionValue)value, process, element);
            if (token == null) {
                return;
            }
            contentSpecification.setStrings(new ContentToken[]{token});
        }
        if (!(value instanceof CSSValueList)) {
            return;
        }
        ArrayList<ContentToken> tokens = new ArrayList<ContentToken>();
        CSSValueList list = (CSSValueList)value;
        int size = list.getLength();
        block0: for (int i = 0; i < size; ++i) {
            CSSValueList sequence = (CSSValueList)list.getItem(i);
            for (int j = 0; j < sequence.getLength(); ++j) {
                CSSValue content = sequence.getItem(j);
                ContentToken token = this.createToken(process, element, content);
                if (token == null) {
                    tokens.clear();
                    continue block0;
                }
                tokens.add(token);
            }
        }
        ContentToken[] contents = tokens.toArray(new ContentToken[tokens.size()]);
        contentSpecification.setStrings(contents);
    }

    private ContentToken createToken(DocumentContext process, LayoutElement element, CSSValue content) {
        if (content instanceof CSSStringValue) {
            CSSStringValue sval = (CSSStringValue)content;
            if (CSSStringType.STRING.equals(sval.getType())) {
                return new StaticTextToken(sval.getValue());
            }
            CSSFunctionValue function = new CSSFunctionValue("url", new CSSValue[]{sval});
            return this.evaluateFunction(function, process, element);
        }
        if (content instanceof CSSFunctionValue) {
            return this.evaluateFunction((CSSFunctionValue)content, process, element);
        }
        if (content instanceof CSSConstant && ContentValues.DOCUMENT_URL.equals(content)) {
            ResourceKey baseKey = process.getContextKey();
            ResourceManager resourceManager = process.getResourceManager();
            URL url = resourceManager.toURL(baseKey);
            if (url != null) {
                return new StaticTextToken(url.toExternalForm());
            }
            return null;
        }
        return null;
    }

    private ContentToken evaluateFunction(CSSFunctionValue function, DocumentContext process, LayoutElement element) {
        StyleValueFunction styleFunction = FunctionFactory.getInstance().getStyleFunction(function.getFunctionName());
        try {
            CSSValue value = styleFunction.evaluate(process, element, function);
            if (value instanceof CSSResourceValue) {
                CSSResourceValue refValue = (CSSResourceValue)value;
                return new ResourceContentToken(refValue.getValue());
            }
            if (value instanceof CSSStringValue) {
                CSSStringValue strval = (CSSStringValue)value;
                return new StaticTextToken(strval.getValue());
            }
            if (value instanceof CSSRawValue) {
                CSSRawValue rawValue = (CSSRawValue)value;
                return new ExternalContentToken(rawValue.getValue());
            }
            return new StaticTextToken(value.getCSSText());
        }
        catch (FunctionEvaluationException e) {
            DebugLog.log((Object)("Evaluation failed " + e));
            return null;
        }
    }
}

