/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed.content;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.css.counter.CounterStyle;
import org.pentaho.reporting.libraries.css.counter.CounterStyleFactory;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.content.ContentStyleKeys;
import org.pentaho.reporting.libraries.css.keys.content.ContentValues;
import org.pentaho.reporting.libraries.css.keys.internal.InternalStyleKeys;
import org.pentaho.reporting.libraries.css.keys.list.ListStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.FunctionEvaluationException;
import org.pentaho.reporting.libraries.css.resolver.function.ContentFunction;
import org.pentaho.reporting.libraries.css.resolver.function.FunctionFactory;
import org.pentaho.reporting.libraries.css.resolver.tokens.ContentToken;
import org.pentaho.reporting.libraries.css.resolver.tokens.computed.CloseQuoteToken;
import org.pentaho.reporting.libraries.css.resolver.tokens.computed.ContentsToken;
import org.pentaho.reporting.libraries.css.resolver.tokens.computed.CounterToken;
import org.pentaho.reporting.libraries.css.resolver.tokens.computed.OpenQuoteToken;
import org.pentaho.reporting.libraries.css.resolver.tokens.statics.StaticTextToken;
import org.pentaho.reporting.libraries.css.resolver.values.ContentSpecification;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSAttrFunction;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSFunctionValue;
import org.pentaho.reporting.libraries.css.values.CSSStringType;
import org.pentaho.reporting.libraries.css.values.CSSStringValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValueList;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ContentResolveHandler
implements ResolveHandler {
    private static final ContentToken[] DEFAULT_CONTENT = new ContentToken[]{ContentsToken.CONTENTS};
    private static final ContentToken[] PSEUDO_CONTENT = new ContentToken[0];
    private CSSValue listCounter;
    private HashMap tokenMapping = new HashMap();

    public ContentResolveHandler() {
        this.tokenMapping.put(ContentValues.CONTENTS, ContentsToken.CONTENTS);
        this.tokenMapping.put(ContentValues.OPEN_QUOTE, new OpenQuoteToken(false));
        this.tokenMapping.put(ContentValues.NO_OPEN_QUOTE, new OpenQuoteToken(true));
        this.tokenMapping.put(ContentValues.CLOSE_QUOTE, new CloseQuoteToken(false));
        this.tokenMapping.put(ContentValues.NO_CLOSE_QUOTE, new CloseQuoteToken(true));
        CSSStringValue param = new CSSStringValue(CSSStringType.STRING, "list-item");
        this.listCounter = new CSSFunctionValue("counter", new CSSValue[]{param});
    }

    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{ContentStyleKeys.COUNTER_RESET, ContentStyleKeys.COUNTER_INCREMENT, ContentStyleKeys.QUOTES, ContentStyleKeys.STRING_SET};
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement element, StyleKey key) {
        LayoutStyle layoutContext = element.getLayoutStyle();
        ContentSpecification contentSpecification = (ContentSpecification)layoutContext.getValue(InternalStyleKeys.INTERNAL_CONTENT);
        CSSValue value = layoutContext.getValue(key);
        if (value instanceof CSSConstant) {
            if (ContentValues.NONE.equals(value)) {
                contentSpecification.setAllowContentProcessing(false);
                contentSpecification.setInhibitContent(false);
                contentSpecification.setContents(PSEUDO_CONTENT);
                return;
            }
            if (ContentValues.INHIBIT.equals(value)) {
                contentSpecification.setAllowContentProcessing(false);
                contentSpecification.setInhibitContent(true);
                contentSpecification.setContents(PSEUDO_CONTENT);
                return;
            }
            if (ContentValues.NORMAL.equals(value)) {
                // empty if block
            }
        }
        contentSpecification.setInhibitContent(false);
        contentSpecification.setAllowContentProcessing(true);
        contentSpecification.setContents(DEFAULT_CONTENT);
        if (value instanceof CSSAttrFunction) {
            ContentToken token = this.evaluateFunction((CSSFunctionValue)value, process, element);
            if (token == null) {
                return;
            }
            contentSpecification.setContents(new ContentToken[]{token});
        }
        if (!(value instanceof CSSValueList)) {
            return;
        }
        ArrayList<ContentToken> tokens = new ArrayList<ContentToken>();
        CSSValueList list = (CSSValueList)value;
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            CSSValueList sequence = (CSSValueList)list.getItem(i);
            for (int j = 0; j < sequence.getLength(); ++j) {
                CSSValue content = sequence.getItem(j);
                ContentToken token = this.createToken(process, element, content);
                if (token == null) {
                    tokens.clear();
                    break;
                }
                tokens.add(token);
            }
            if (tokens.isEmpty()) continue;
            ContentToken[] contents = tokens.toArray(new ContentToken[tokens.size()]);
            contentSpecification.setContents(contents);
            return;
        }
    }

    private void processListItem(DocumentContext process, LayoutElement element, ContentSpecification contentSpecification) {
        ContentToken token;
        contentSpecification.setAllowContentProcessing(false);
        contentSpecification.setInhibitContent(false);
        LayoutStyle layoutContext = element.getLayoutStyle();
        CSSValue value = layoutContext.getValue(ListStyleKeys.LIST_STYLE_IMAGE);
        if (value != null && (token = this.createToken(process, element, value)) != null) {
            contentSpecification.setContents(new ContentToken[]{token});
            return;
        }
        token = this.createToken(process, element, this.listCounter);
        if (token instanceof CounterToken) {
            CounterToken counterToken = (CounterToken)token;
            CounterStyle style = counterToken.getStyle();
            String suffix = style.getSuffix();
            if (suffix == null || suffix.length() == 0) {
                contentSpecification.setContents(new ContentToken[]{token});
            } else {
                contentSpecification.setContents(new ContentToken[]{counterToken, new StaticTextToken(suffix)});
            }
        } else {
            contentSpecification.setContents(new ContentToken[]{token});
        }
    }

    private ContentToken createToken(DocumentContext process, LayoutElement element, CSSValue content) {
        try {
            if (content instanceof CSSStringValue) {
                CSSStringValue sval = (CSSStringValue)content;
                if (CSSStringType.STRING.equals(sval.getType())) {
                    return new StaticTextToken(sval.getValue());
                }
                CSSFunctionValue function = new CSSFunctionValue("url", new CSSValue[]{sval});
                return this.evaluateFunction(function, process, element);
            }
            if (content instanceof CSSConstant) {
                if (ContentValues.DOCUMENT_URL.equals(content)) {
                    ResourceKey baseKey = process.getContextKey();
                    ResourceManager resourceManager = process.getResourceManager();
                    URL url = resourceManager.toURL(baseKey);
                    if (url != null) {
                        return new StaticTextToken(url.toExternalForm());
                    }
                    return null;
                }
                ContentToken token = (ContentToken)this.tokenMapping.get(content);
                if (token != null) {
                    return token;
                }
                return this.resolveContentAlias(content);
            }
            if (content instanceof CSSFunctionValue) {
                return this.evaluateFunction((CSSFunctionValue)content, process, element);
            }
        }
        catch (Exception e) {
            DebugLog.log((Object)("Content-Resolver: Failed to evaluate " + content));
        }
        return null;
    }

    private ContentToken resolveContentAlias(CSSValue content) {
        if (ContentValues.FOOTNOTE.equals(content)) {
            CounterStyle style = CounterStyleFactory.getInstance().getCounterStyle("normal");
            return new CounterToken("footnote", style);
        }
        if (ContentValues.ENDNOTE.equals(content)) {
            CounterStyle style = CounterStyleFactory.getInstance().getCounterStyle("normal");
            return new CounterToken("endnote", style);
        }
        if (ContentValues.SECTIONNOTE.equals(content)) {
            CounterStyle style = CounterStyleFactory.getInstance().getCounterStyle("normal");
            return new CounterToken("section-note", style);
        }
        if (ContentValues.LISTITEM.equals(content)) {
            CounterStyle style = CounterStyleFactory.getInstance().getCounterStyle("normal");
            return new CounterToken("list-item", style);
        }
        return null;
    }

    private ContentToken evaluateFunction(CSSFunctionValue function, DocumentContext process, LayoutElement element) {
        ContentFunction styleFunction = FunctionFactory.getInstance().getContentFunction(function.getFunctionName());
        if (styleFunction == null) {
            return null;
        }
        try {
            return styleFunction.evaluate(process, element, function);
        }
        catch (FunctionEvaluationException e) {
            DebugLog.log((Object)("Evaluation failed " + e));
            return null;
        }
    }
}

