/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed.color;

import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.color.CSSSystemColors;
import org.pentaho.reporting.libraries.css.keys.color.ColorStyleKeys;
import org.pentaho.reporting.libraries.css.keys.color.HtmlColors;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.FunctionEvaluationException;
import org.pentaho.reporting.libraries.css.resolver.function.FunctionFactory;
import org.pentaho.reporting.libraries.css.resolver.function.StyleValueFunction;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;
import org.pentaho.reporting.libraries.css.util.ColorUtil;
import org.pentaho.reporting.libraries.css.values.CSSColorValue;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSFunctionValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class ColorResolveHandler
implements ResolveHandler {
    private static final StyleKey[] EMPTY_KEYS = new StyleKey[0];

    @Override
    public StyleKey[] getRequiredStyles() {
        return EMPTY_KEYS;
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        LayoutStyle style = currentNode.getLayoutStyle();
        CSSValue value = style.getValue(key);
        if (value instanceof CSSColorValue) {
            return;
        }
        if (value instanceof CSSFunctionValue) {
            CSSFunctionValue functionValue = (CSSFunctionValue)value;
            StyleValueFunction function = FunctionFactory.getInstance().getStyleFunction(functionValue.getFunctionName());
            if (function == null) {
                value = HtmlColors.BLACK;
            } else {
                try {
                    value = function.evaluate(process, currentNode, functionValue);
                }
                catch (FunctionEvaluationException e) {
                    value = HtmlColors.BLACK;
                }
            }
            if (value instanceof CSSColorValue) {
                style.setValue(key, value);
                return;
            }
        }
        if (!(value instanceof CSSConstant)) {
            style.setValue(key, HtmlColors.BLACK);
            return;
        }
        if (CSSSystemColors.CURRENT_COLOR.equals(value)) {
            style.setValue(key, this.getCurrentColor(currentNode));
            return;
        }
        CSSValue c = ColorUtil.parseIdentColor(value.getCSSText());
        if (c != null) {
            style.setValue(key, c);
        } else {
            style.setValue(key, HtmlColors.BLACK);
        }
    }

    protected CSSColorValue getCurrentColor(LayoutElement currentNode) {
        LayoutStyle layoutContext;
        CSSValue value;
        LayoutElement parent = currentNode.getParentLayoutElement();
        if (parent != null && (value = (layoutContext = parent.getLayoutStyle()).getValue(ColorStyleKeys.COLOR)) instanceof CSSColorValue) {
            return (CSSColorValue)value;
        }
        return HtmlColors.BLACK;
    }
}

