/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values.computed.box;

import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.box.BoxStyleKeys;
import org.pentaho.reporting.libraries.css.keys.box.DisplayModel;
import org.pentaho.reporting.libraries.css.keys.box.DisplayRole;
import org.pentaho.reporting.libraries.css.keys.box.Floating;
import org.pentaho.reporting.libraries.css.keys.positioning.PositioningStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.computed.ConstantsResolveHandler;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class FloatResolveHandler
extends ConstantsResolveHandler {
    public FloatResolveHandler() {
        this.addNormalizeValue(Floating.BOTTOM);
        this.addNormalizeValue(Floating.LEFT);
        this.addNormalizeValue(Floating.END);
        this.addNormalizeValue(Floating.INSIDE);
        this.addNormalizeValue(Floating.IN_COLUMN);
        this.addNormalizeValue(Floating.MID_COLUMN);
        this.addNormalizeValue(Floating.NONE);
        this.addNormalizeValue(Floating.OUTSIDE);
        this.addNormalizeValue(Floating.RIGHT);
        this.addNormalizeValue(Floating.START);
        this.addNormalizeValue(Floating.TOP);
        this.setFallback(Floating.NONE);
    }

    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{BoxStyleKeys.DISPLAY_ROLE, PositioningStyleKeys.POSITION};
    }

    @Override
    public void resolve(DocumentContext process, LayoutElement currentNode, StyleKey key) {
        LayoutStyle layoutContext = currentNode.getLayoutStyle();
        CSSValue displayRole = layoutContext.getValue(BoxStyleKeys.DISPLAY_ROLE);
        CSSValue floating = DisplayRole.NONE.equals(displayRole) ? Floating.NONE : this.resolveValue(process, currentNode, key);
        if (!Floating.NONE.equals(floating)) {
            layoutContext.setValue(BoxStyleKeys.DISPLAY_MODEL, DisplayModel.BLOCK_INSIDE);
            layoutContext.setValue(BoxStyleKeys.DISPLAY_ROLE, DisplayRole.BLOCK);
        }
        layoutContext.setValue(key, Floating.NONE);
    }
}

