/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.css.LibCssBoot;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.keys.internal.InternalStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.model.StyleKeyRegistry;
import org.pentaho.reporting.libraries.css.resolver.values.ContentSpecification;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandlerModule;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandlerSorter;
import org.pentaho.reporting.libraries.css.values.CSSAutoValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class ResolverFactory {
    private static final Log logger = LogFactory.getLog(ResolverFactory.class);
    private static final String AUTO_PREFIX = "org.jfree.layouting.resolver.auto.";
    private static final String COMPUTED_PREFIX = "org.jfree.layouting.resolver.computed.";
    private static final String PERCENTAGE_PREFIX = "org.jfree.layouting.resolver.percentages.";
    private static ResolverFactory factory;
    private ResolveHandlerModule[] handlers = null;
    private StyleKeyRegistry registry = StyleKeyRegistry.getRegistry();

    public static synchronized ResolverFactory getInstance() {
        if (factory == null) {
            factory = new ResolverFactory();
            factory.registerDefaults();
        }
        return factory;
    }

    private ResolverFactory() {
    }

    public void registerDefaults() {
        ArrayList<ResolveHandlerModule> handlerList = new ArrayList<ResolveHandlerModule>();
        HashMap autoHandlers = this.loadModules(AUTO_PREFIX);
        HashMap compHandlers = this.loadModules(COMPUTED_PREFIX);
        HashMap percHandlers = this.loadModules(PERCENTAGE_PREFIX);
        HashSet keys = new HashSet();
        keys.addAll(autoHandlers.keySet());
        keys.addAll(compHandlers.keySet());
        keys.addAll(percHandlers.keySet());
        for (StyleKey key : keys) {
            ResolveHandler autoHandler = (ResolveHandler)autoHandlers.get(key);
            ResolveHandler compHandler = (ResolveHandler)compHandlers.get(key);
            ResolveHandler percHandler = (ResolveHandler)percHandlers.get(key);
            handlerList.add(new ResolveHandlerModule(key, autoHandler, compHandler, percHandler));
        }
        this.handlers = handlerList.toArray(new ResolveHandlerModule[handlerList.size()]);
        this.handlers = ResolveHandlerSorter.sort(this.handlers);
    }

    private HashMap loadModules(String configPrefix) {
        HashMap<StyleKey, ResolveHandler> handlers = new HashMap<StyleKey, ResolveHandler>();
        Configuration config = LibCssBoot.getInstance().getGlobalConfig();
        Iterator sit = config.findPropertyKeys(configPrefix);
        int length = configPrefix.length();
        while (sit.hasNext()) {
            String configkey = (String)sit.next();
            String name = configkey.substring(length).toLowerCase();
            StyleKey key = this.registry.findKeyByName(name);
            if (key == null) {
                logger.warn((Object)("Invalid stylekey for resolver: " + name));
                continue;
            }
            String c = config.getConfigProperty(configkey);
            ResolveHandler module = (ResolveHandler)ObjectUtilities.loadAndInstantiate((String)c, ResolverFactory.class, ResolveHandler.class);
            if (module != null) {
                handlers.put(key, module);
                continue;
            }
            logger.warn((Object)("Invalid resolver implementation: " + c));
        }
        return handlers;
    }

    public void performResolve(DocumentContext process, LayoutElement node) {
        node.getLayoutStyle().setValue(InternalStyleKeys.INTERNAL_CONTENT, new ContentSpecification());
        for (int i = 0; i < this.handlers.length; ++i) {
            ResolveHandler percValueHandler;
            ResolveHandler compValueHandler;
            ResolveHandlerModule handler = this.handlers[i];
            StyleKey key = handler.getKey();
            CSSValue value = node.getLayoutStyle().getValue(key);
            ResolveHandler autoValueHandler = handler.getAutoValueHandler();
            if (autoValueHandler != null && value instanceof CSSAutoValue) {
                autoValueHandler.resolve(process, node, key);
            }
            if ((compValueHandler = handler.getComputedValueHandler()) != null) {
                compValueHandler.resolve(process, node, key);
            }
            if ((percValueHandler = handler.getPercentagesValueHandler()) == null) continue;
            percValueHandler.resolve(process, node, key);
        }
    }
}

