/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.values;

import java.util.HashSet;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.resolver.values.ResolveHandler;

public final class ResolveHandlerModule {
    private StyleKey key;
    private ResolveHandler autoValueHandler;
    private ResolveHandler computedValueHandler;
    private ResolveHandler percentagesValueHandler;
    private StyleKey[] dependentKeys;
    private int weight;

    public ResolveHandlerModule(StyleKey key, ResolveHandler autoValueHandler, ResolveHandler computedValueHandler, ResolveHandler percentagesValueHandler) {
        StyleKey styleKey;
        int i;
        StyleKey[] keys;
        this.key = key;
        this.autoValueHandler = autoValueHandler;
        this.computedValueHandler = computedValueHandler;
        this.percentagesValueHandler = percentagesValueHandler;
        HashSet<StyleKey> dependentKeys = new HashSet<StyleKey>();
        if (autoValueHandler != null) {
            keys = autoValueHandler.getRequiredStyles();
            for (i = 0; i < keys.length; ++i) {
                styleKey = keys[i];
                dependentKeys.add(styleKey);
            }
        }
        if (computedValueHandler != null) {
            keys = computedValueHandler.getRequiredStyles();
            for (i = 0; i < keys.length; ++i) {
                styleKey = keys[i];
                dependentKeys.add(styleKey);
            }
        }
        if (percentagesValueHandler != null) {
            keys = percentagesValueHandler.getRequiredStyles();
            for (i = 0; i < keys.length; ++i) {
                styleKey = keys[i];
                dependentKeys.add(styleKey);
            }
        }
        this.dependentKeys = dependentKeys.toArray(new StyleKey[dependentKeys.size()]);
    }

    public StyleKey getKey() {
        return this.key;
    }

    public ResolveHandler getAutoValueHandler() {
        return this.autoValueHandler;
    }

    public ResolveHandler getComputedValueHandler() {
        return this.computedValueHandler;
    }

    public ResolveHandler getPercentagesValueHandler() {
        return this.percentagesValueHandler;
    }

    public StyleKey[] getDependentKeys() {
        return this.dependentKeys;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }
}

