/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.impl;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.css.LibCssBoot;
import org.pentaho.reporting.libraries.css.dom.DefaultLayoutStyle;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.content.ContentStyleKeys;
import org.pentaho.reporting.libraries.css.model.CSSDeclarationRule;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.model.StyleKeyRegistry;
import org.pentaho.reporting.libraries.css.model.StyleRule;
import org.pentaho.reporting.libraries.css.model.StyleSheet;
import org.pentaho.reporting.libraries.css.namespace.NamespaceCollection;
import org.pentaho.reporting.libraries.css.resolver.FunctionEvaluationException;
import org.pentaho.reporting.libraries.css.resolver.StyleResolver;
import org.pentaho.reporting.libraries.css.resolver.function.StyleValueFunction;
import org.pentaho.reporting.libraries.css.values.CSSFunctionValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValueList;
import org.pentaho.reporting.libraries.css.values.CSSValuePair;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public abstract class AbstractStyleResolver
implements StyleResolver {
    private static final String INITIAL_CSS_PREFIX = "org.pentaho.reporting.libraries.css.styles.initial";
    private static final String CSS_VALUE_FUNCTIONS_PREFIX = "org.pentaho.reporting.libraries.css.styles.value-functions.";
    private static final Log logger = LogFactory.getLog(AbstractStyleResolver.class);
    private LayoutStyle initialStyle;
    private DocumentContext documentContext;
    private NamespaceCollection namespaces;
    private StyleKey[] keys;
    private HashMap functions = new HashMap();

    protected AbstractStyleResolver() {
    }

    @Override
    public void initialize(DocumentContext documentContext) {
        this.documentContext = documentContext;
        this.namespaces = documentContext.getNamespaces();
        this.initializeFunctions();
    }

    private void initializeFunctions() {
        Configuration config = LibCssBoot.getInstance().getGlobalConfig();
        Iterator it = config.findPropertyKeys(CSS_VALUE_FUNCTIONS_PREFIX);
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = config.getConfigProperty(key);
            String name = key.substring(CSS_VALUE_FUNCTIONS_PREFIX.length()).toLowerCase();
            Object o = ObjectUtilities.loadAndInstantiate((String)value, AbstractStyleResolver.class, StyleValueFunction.class);
            if (o == null) continue;
            this.functions.put(name, o);
        }
    }

    protected void loadInitialStyle(DocumentContext context) {
        this.initialStyle = new DefaultLayoutStyle();
        try {
            ResourceManager manager = this.documentContext.getResourceManager();
            Configuration config = LibCssBoot.getInstance().getGlobalConfig();
            Iterator it = config.findPropertyKeys(INITIAL_CSS_PREFIX);
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = config.getConfigProperty(key);
                Resource resource = manager.createDirectly((Object)value, StyleSheet.class);
                StyleSheet initialStyleSheet = (StyleSheet)resource.getResource();
                int rc = initialStyleSheet.getRuleCount();
                for (int i = 0; i < rc; ++i) {
                    StyleRule rule = initialStyleSheet.getRule(i);
                    if (!(rule instanceof CSSDeclarationRule)) continue;
                    CSSDeclarationRule drule = (CSSDeclarationRule)rule;
                    this.copyStyleInformation(this.initialStyle, drule, null);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Initial-StyleSheet could not be parsed. This is a FATAL error.", (Throwable)e);
            throw new IllegalStateException("Initial-StyleSheet could not be parsed. This is a FATAL error.");
        }
    }

    protected void copyStyleInformation(LayoutStyle target, CSSDeclarationRule rule, LayoutElement element) {
        try {
            CSSValue value;
            StyleKey key;
            int i;
            StyleRule parentRule = rule.getParentRule();
            if (parentRule instanceof CSSDeclarationRule) {
                this.copyStyleInformation(target, (CSSDeclarationRule)parentRule, element);
            }
            if (element == null) {
                StyleKey[] propertyKeys = rule.getPropertyKeysAsArray();
                for (int i2 = 0; i2 < propertyKeys.length; ++i2) {
                    StyleKey key2 = propertyKeys[i2];
                    CSSValue propertyCSSValue = rule.getPropertyCSSValue(key2);
                    if (propertyCSSValue == null) continue;
                    target.setValue(key2, propertyCSSValue);
                }
                return;
            }
            StyleKey[] propertyKeys = rule.getPropertyKeysAsArray();
            CSSValue[] values = rule.getStyleValues();
            for (i = 0; i < values.length; ++i) {
                key = propertyKeys[i];
                value = rule.getPropertyCSSValue(key);
                values[i] = ContentStyleKeys.CONTENT.equals(key) || ContentStyleKeys.STRING_DEFINE.equals(key) || ContentStyleKeys.STRING_SET.equals(key) ? value : this.resolveValue(value, element);
            }
            for (i = 0; i < values.length; ++i) {
                key = propertyKeys[i];
                value = values[i];
                if (value == null) continue;
                target.setValue(key, value);
            }
        }
        catch (FunctionEvaluationException functionEvaluationException) {
            // empty catch block
        }
    }

    protected CSSValue resolveValue(CSSValue value, LayoutElement element) throws FunctionEvaluationException {
        if (element == null) {
            return value;
        }
        if (value == null) {
            return null;
        }
        if (!this.containsResolveableFunction(value)) {
            return value;
        }
        if (value instanceof CSSFunctionValue) {
            CSSFunctionValue functionValue = (CSSFunctionValue)value;
            String name = functionValue.getFunctionName().toLowerCase();
            StyleValueFunction o = (StyleValueFunction)this.functions.get(name);
            if (o == null) {
                throw new FunctionEvaluationException("No such function registered: " + name);
            }
            return o.evaluate(this.documentContext, element, (CSSFunctionValue)value);
        }
        if (value instanceof CSSValueList) {
            CSSValueList list = (CSSValueList)value;
            int length = list.getLength();
            CSSValue[] retValus = new CSSValue[length];
            for (int i = 0; i < length; ++i) {
                CSSValue item = list.getItem(i);
                retValus[i] = this.resolveValue(item, element);
            }
            return new CSSValueList(retValus);
        }
        if (value instanceof CSSValuePair) {
            CSSValuePair pair = (CSSValuePair)value;
            return new CSSValuePair(this.resolveValue(pair.getFirstValue(), element), this.resolveValue(pair.getSecondValue(), element));
        }
        return value;
    }

    protected boolean containsResolveableFunction(CSSValue value) {
        if (value == null) {
            return false;
        }
        if (value instanceof CSSFunctionValue) {
            return true;
        }
        if (value instanceof CSSValueList) {
            CSSValueList list = (CSSValueList)value;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                CSSValue item = list.getItem(i);
                if (!this.containsResolveableFunction(item)) continue;
                return true;
            }
            return false;
        }
        if (value instanceof CSSValuePair) {
            CSSValuePair pair = (CSSValuePair)value;
            if (this.containsResolveableFunction(pair.getFirstValue())) {
                return true;
            }
            return this.containsResolveableFunction(pair.getSecondValue());
        }
        return false;
    }

    @Override
    public LayoutStyle getInitialStyle() {
        return this.initialStyle;
    }

    protected DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    protected StyleKey[] getKeys() {
        if (this.keys == null) {
            this.keys = StyleKeyRegistry.getRegistry().getKeys();
        }
        return this.keys;
    }

    protected NamespaceCollection getNamespaces() {
        return this.namespaces;
    }

    protected abstract void resolveOutOfContext(LayoutElement var1);
}

