/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.text;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.css.keys.text.TextStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSCompoundValueReadHandler;
import org.pentaho.reporting.libraries.css.parser.stylehandler.text.TextOverflowEllipsisReadHandler;
import org.pentaho.reporting.libraries.css.parser.stylehandler.text.TextOverflowModeReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSInheritValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class TextOverflowReadHandler
implements CSSCompoundValueReadHandler {
    private TextOverflowModeReadHandler modeReadHandler = new TextOverflowModeReadHandler();
    private TextOverflowEllipsisReadHandler ellipsisReadHandler = new TextOverflowEllipsisReadHandler();

    @Override
    public Map createValues(LexicalUnit unit) {
        if (unit.getLexicalUnitType() == 12) {
            HashMap<StyleKey, CSSInheritValue> map = new HashMap<StyleKey, CSSInheritValue>();
            map.put(TextStyleKeys.TEXT_OVERFLOW_MODE, CSSInheritValue.getInstance());
            map.put(TextStyleKeys.TEXT_OVERFLOW_ELLIPSIS, CSSInheritValue.getInstance());
            return map;
        }
        CSSValue mode = this.modeReadHandler.createValue(null, unit);
        if (mode != null) {
            unit = unit.getNextLexicalUnit();
        }
        CSSValue ellipsis = unit != null ? this.ellipsisReadHandler.createValue(null, unit) : null;
        HashMap<StyleKey, CSSValue> map = new HashMap<StyleKey, CSSValue>();
        if (mode != null) {
            map.put(TextStyleKeys.TEXT_OVERFLOW_MODE, mode);
        }
        if (ellipsis != null) {
            map.put(TextStyleKeys.TEXT_OVERFLOW_ELLIPSIS, ellipsis);
        }
        return map;
    }

    @Override
    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{TextStyleKeys.TEXT_OVERFLOW_MODE, TextStyleKeys.TEXT_OVERFLOW_ELLIPSIS};
    }
}

