/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.border;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.css.keys.border.BorderStyleKeys;
import org.pentaho.reporting.libraries.css.keys.border.BorderWidth;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSCompoundValueReadHandler;
import org.pentaho.reporting.libraries.css.parser.stylehandler.AbstractWidthReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class BorderWidthReadHandler
extends AbstractWidthReadHandler
implements CSSCompoundValueReadHandler {
    public BorderWidthReadHandler() {
        super(true, false);
    }

    protected BorderWidthReadHandler(boolean allowPercentages, boolean allowAuto) {
        super(allowPercentages, allowAuto);
    }

    @Override
    protected CSSValue parseWidth(LexicalUnit value) {
        if (value.getLexicalUnitType() == 35) {
            if (value.getStringValue().equalsIgnoreCase("thin")) {
                return BorderWidth.THIN;
            }
            if (value.getStringValue().equalsIgnoreCase("medium")) {
                return BorderWidth.MEDIUM;
            }
            if (value.getStringValue().equalsIgnoreCase("thick")) {
                return BorderWidth.THICK;
            }
        }
        return super.parseWidth(value);
    }

    @Override
    public Map createValues(LexicalUnit unit) {
        CSSValue leftWidth;
        CSSValue bottomWidth;
        CSSValue rightWidth;
        CSSValue topWidth = this.parseWidth(unit);
        if (topWidth == null) {
            return null;
        }
        if ((unit = unit.getNextLexicalUnit()) == null) {
            rightWidth = topWidth;
        } else {
            rightWidth = this.parseWidth(unit);
            if (rightWidth == null) {
                return null;
            }
            unit = unit.getNextLexicalUnit();
        }
        if (unit == null) {
            bottomWidth = topWidth;
        } else {
            bottomWidth = this.parseWidth(unit);
            if (bottomWidth == null) {
                return null;
            }
            unit = unit.getNextLexicalUnit();
        }
        if (unit == null) {
            leftWidth = rightWidth;
        } else {
            leftWidth = this.parseWidth(unit);
            if (leftWidth == null) {
                return null;
            }
        }
        HashMap<StyleKey, CSSValue> map = new HashMap<StyleKey, CSSValue>();
        map.put(BorderStyleKeys.BORDER_TOP_WIDTH, topWidth);
        map.put(BorderStyleKeys.BORDER_RIGHT_WIDTH, rightWidth);
        map.put(BorderStyleKeys.BORDER_BOTTOM_WIDTH, bottomWidth);
        map.put(BorderStyleKeys.BORDER_LEFT_WIDTH, leftWidth);
        return map;
    }

    @Override
    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{BorderStyleKeys.BORDER_TOP_WIDTH, BorderStyleKeys.BORDER_RIGHT_WIDTH, BorderStyleKeys.BORDER_BOTTOM_WIDTH, BorderStyleKeys.BORDER_LEFT_WIDTH};
    }
}

