/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.border;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.css.keys.border.BorderStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSCompoundValueReadHandler;
import org.pentaho.reporting.libraries.css.parser.CSSValueFactory;
import org.pentaho.reporting.libraries.css.parser.stylehandler.border.BorderStyleReadHandler;
import org.pentaho.reporting.libraries.css.parser.stylehandler.color.ColorReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class BorderBreakReadHandler
extends BorderStyleReadHandler
implements CSSCompoundValueReadHandler {
    @Override
    public Map createValues(LexicalUnit unit) {
        CSSConstant style;
        CSSNumericValue width = CSSValueFactory.createLengthValue(unit);
        if (width != null) {
            unit = unit.getNextLexicalUnit();
        }
        if (unit != null) {
            style = (CSSConstant)this.lookupValue(unit);
            if (style != null) {
                unit = unit.getNextLexicalUnit();
            }
        } else {
            style = null;
        }
        CSSValue color = unit != null ? ColorReadHandler.createColorValue(unit) : null;
        HashMap<StyleKey, CSSValue> map = new HashMap<StyleKey, CSSValue>();
        if (width != null) {
            map.put(BorderStyleKeys.BORDER_BREAK_WIDTH, width);
        }
        if (style != null) {
            map.put(BorderStyleKeys.BORDER_BREAK_STYLE, style);
        }
        if (color != null) {
            map.put(BorderStyleKeys.BORDER_BREAK_COLOR, color);
        }
        return map;
    }
}

