/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser;

import java.io.IOException;
import java.io.InputStream;
import org.pentaho.reporting.libraries.css.model.StyleKeyRegistry;
import org.pentaho.reporting.libraries.css.model.StyleSheet;
import org.pentaho.reporting.libraries.css.parser.CSSParserContext;
import org.pentaho.reporting.libraries.css.parser.CSSParserFactory;
import org.pentaho.reporting.libraries.css.parser.CSSParserInstantiationException;
import org.pentaho.reporting.libraries.css.parser.StyleSheetHandler;
import org.pentaho.reporting.libraries.resourceloader.CompoundResource;
import org.pentaho.reporting.libraries.resourceloader.DependencyCollector;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;

public class StyleSheetFactory
implements ResourceFactory {
    public Resource create(ResourceManager manager, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        try {
            long version;
            ResourceKey key;
            Parser parser = CSSParserFactory.getInstance().createCSSParser();
            if (context == null) {
                key = data.getKey();
                version = data.getVersion(manager);
            } else {
                key = context;
                version = -1L;
            }
            StyleSheetHandler handler = new StyleSheetHandler();
            handler.init(StyleKeyRegistry.getRegistry(), manager, key, version, null);
            parser.setDocumentHandler((DocumentHandler)handler);
            parser.setErrorHandler((ErrorHandler)handler);
            InputStream stream = data.getResourceAsStream(manager);
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(stream);
            parser.parseStyleSheet(inputSource);
            DependencyCollector dependencies = handler.getDependencies();
            if (context != null) {
                dependencies.add(data.getKey(), data.getVersion(manager));
            }
            CSSParserContext.getContext().destroy();
            return new CompoundResource(data.getKey(), dependencies, (Object)handler.getStyleSheet(), this.getFactoryType());
        }
        catch (CSSParserInstantiationException e) {
            throw new ResourceCreationException("Failed to parse the stylesheet.", (Exception)e);
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Failed to load the stylesheet.", (Exception)e);
        }
    }

    public Class getFactoryType() {
        return StyleSheet.class;
    }

    public void initializeDefaults() {
    }
}

