/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.counter;

import java.util.HashMap;
import java.util.Iterator;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.css.LibCssBoot;
import org.pentaho.reporting.libraries.css.counter.CounterStyle;
import org.pentaho.reporting.libraries.css.counter.numeric.DecimalCounterStyle;

public class CounterStyleFactory {
    private static final CounterStyle DEFAULTCOUNTER = new DecimalCounterStyle();
    private static CounterStyleFactory factory;
    public static final String PREFIX = "org.pentaho.reporting.libraries.css.counter.numbering.";
    private HashMap knownCounters = new HashMap();

    public static synchronized CounterStyleFactory getInstance() {
        if (factory == null) {
            factory = new CounterStyleFactory();
            factory.registerDefaults();
        }
        return factory;
    }

    private CounterStyleFactory() {
    }

    public void registerDefaults() {
        Configuration config = LibCssBoot.getInstance().getGlobalConfig();
        Iterator it = config.findPropertyKeys(PREFIX);
        while (it.hasNext()) {
            Object o;
            String key = (String)it.next();
            String counterClass = config.getConfigProperty(key);
            if (counterClass == null || !((o = ObjectUtilities.loadAndInstantiate((String)counterClass, CounterStyleFactory.class, CounterStyle.class)) instanceof CounterStyle)) continue;
            String name = key.substring(PREFIX.length());
            this.knownCounters.put(name, o);
        }
    }

    public CounterStyle getCounterStyle(String name) {
        CounterStyle cs = (CounterStyle)this.knownCounters.get(name);
        if (cs != null) {
            return cs;
        }
        return DEFAULTCOUNTER;
    }
}

