/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.googleanalytics;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.analytics.Analytics;
import com.google.api.services.analytics.AnalyticsScopes;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.util.Assert;
import org.pentaho.di.core.vfs.KettleVFS;

public class GoogleAnalyticsApiFacade {
    private Analytics analytics;
    private final HttpTransport httpTransport;

    public static GoogleAnalyticsApiFacade createFor(String application, String oauthServiceAccount, String oauthKeyFile) throws GeneralSecurityException, IOException, KettleFileException {
        return new GoogleAnalyticsApiFacade((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)JacksonFactory.getDefaultInstance(), application, oauthServiceAccount, new File(KettleVFS.getFileObject((String)oauthKeyFile).getURL().getPath()));
    }

    public GoogleAnalyticsApiFacade(HttpTransport httpTransport, JsonFactory jsonFactory, String application, String oathServiceEmail, File keyFile) throws IOException, GeneralSecurityException {
        Assert.assertNotNull((Object)httpTransport, (String)"HttpTransport cannot be null");
        Assert.assertNotNull((Object)jsonFactory, (String)"JsonFactory cannot be null");
        Assert.assertNotBlank((String)application, (String)"Application name cannot be empty");
        Assert.assertNotBlank((String)oathServiceEmail, (String)"OAuth Service Email name cannot be empty");
        Assert.assertNotNull((Object)keyFile, (String)"OAuth secret key file cannot be null");
        this.httpTransport = httpTransport;
        GoogleCredential credential = new GoogleCredential.Builder().setTransport(httpTransport).setJsonFactory(jsonFactory).setServiceAccountScopes((Collection)AnalyticsScopes.all()).setServiceAccountId(oathServiceEmail).setServiceAccountPrivateKeyFromP12File(keyFile).build();
        this.analytics = new Analytics.Builder(httpTransport, jsonFactory, (HttpRequestInitializer)credential).setApplicationName(application).build();
    }

    public void close() throws IOException {
        this.httpTransport.shutdown();
    }

    public Analytics getAnalytics() {
        return this.analytics;
    }
}

