/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.MultisetSqlType;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;

class UnnestNamespace
extends AbstractNamespace {
    private final SqlCall unnest;
    private final SqlValidatorScope scope;

    UnnestNamespace(SqlValidatorImpl validator, SqlCall unnest, SqlValidatorScope scope, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        assert (scope != null);
        assert (unnest.getOperator() == SqlStdOperatorTable.UNNEST);
        this.unnest = unnest;
        this.scope = scope;
    }

    protected RelDataType validateImpl() {
        this.validator.validateCall(this.unnest, this.scope);
        RelDataType type = this.unnest.getOperator().validateOperands(this.validator, this.scope, this.unnest);
        if (type.isStruct()) {
            return type;
        }
        return this.validator.getTypeFactory().builder().add(this.validator.deriveAlias(this.unnest, 0), type).build();
    }

    private RelDataType inferReturnType() {
        Object operand = this.unnest.operand(0);
        RelDataType type = this.validator.getValidatedNodeType((SqlNode)operand);
        if (type.isStruct()) {
            type = type.getFieldList().get(0).getType();
        }
        MultisetSqlType t = (MultisetSqlType)type;
        return t.getComponentType();
    }

    public SqlNode getNode() {
        return this.unnest;
    }
}

