/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.util.Pair;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexExecutable {
    public static final String GENERATED_CLASS_NAME = "Reducer";
    private final Function1<DataContext, Object[]> compiledFunction;
    private final String code;
    private DataContext dataContext;

    public RexExecutable(String code, Object reason) {
        try {
            this.compiledFunction = (Function1)ClassBodyEvaluator.createFastClassBodyEvaluator((Scanner)new Scanner(null, (Reader)new StringReader(code)), (String)GENERATED_CLASS_NAME, Utilities.class, (Class[])new Class[]{Function1.class, Serializable.class}, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (CompileException e) {
            throw new RuntimeException("While compiling " + reason, e);
        }
        catch (IOException e) {
            throw new RuntimeException("While compiling " + reason, e);
        }
        this.code = code;
    }

    public void setDataContext(DataContext dataContext) {
        this.dataContext = dataContext;
    }

    public void reduce(RexBuilder rexBuilder, List<RexNode> constExps, List<RexNode> reducedValues) {
        Object[] values = (Object[])this.compiledFunction.apply((Object)this.dataContext);
        assert (values.length == constExps.size());
        List<Object> valueList = Arrays.asList(values);
        for (Pair<RexNode, Object> value : Pair.zip(constExps, valueList)) {
            reducedValues.add(rexBuilder.makeLiteral(value.right, ((RexNode)value.left).getType(), true));
        }
        Hook.EXPRESSION_REDUCER.run(Pair.of(this.code, values));
    }

    public Function1<DataContext, Object[]> getFunction() {
        return this.compiledFunction;
    }

    public Object[] execute() {
        return (Object[])this.compiledFunction.apply((Object)this.dataContext);
    }

    public String getSource() {
        return this.code;
    }
}

