/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.util.Util;

public class UnionMergeRule
extends RelOptRule {
    public static final UnionMergeRule INSTANCE = new UnionMergeRule();

    private UnionMergeRule() {
        super(UnionMergeRule.operand(LogicalUnion.class, UnionMergeRule.operand(RelNode.class, UnionMergeRule.any()), UnionMergeRule.operand(RelNode.class, UnionMergeRule.any())));
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalUnion bottomUnion;
        LogicalUnion topUnion = (LogicalUnion)call.rel(0);
        if (call.rel(2) instanceof LogicalUnion) {
            bottomUnion = (LogicalUnion)call.rel(2);
        } else if (call.rel(1) instanceof LogicalUnion) {
            bottomUnion = (LogicalUnion)call.rel(1);
        } else {
            return;
        }
        if (!topUnion.all || !bottomUnion.all) {
            return;
        }
        ArrayList<RelNode> unionInputs = new ArrayList<RelNode>();
        if (call.rel(2) instanceof LogicalUnion) {
            assert (topUnion.getInputs().size() == 2);
            unionInputs.add(topUnion.getInput(0));
            unionInputs.addAll(bottomUnion.getInputs());
        } else {
            unionInputs.addAll(bottomUnion.getInputs());
            unionInputs.addAll(Util.skip(topUnion.getInputs()));
        }
        assert (unionInputs.size() == bottomUnion.getInputs().size() + topUnion.getInputs().size() - 1);
        LogicalUnion newUnion = new LogicalUnion(topUnion.getCluster(), unionInputs, true);
        call.transformTo(newUnion);
    }
}

