/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.xml.dom4j;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.util.messages.Messages;
import org.pentaho.platform.util.xml.XMLParserFactoryProducer;
import org.xml.sax.EntityResolver;

public class XmlDom4JHelper {
    private static final Log logger = LogFactory.getLog(XmlDom4JHelper.class);

    public static Document getDocFromString(String strXml, EntityResolver resolver) throws XmlParseException {
        Document document = null;
        try {
            document = XmlDom4JHelper.getDocFromStream(new ByteArrayInputStream(strXml.getBytes()), resolver);
        }
        catch (DocumentException e) {
            throw new XmlParseException(Messages.getInstance().getErrorString("XmlDom4JHelper.ERROR_0001_UNABLE_TO_GET_DOCUMENT_FROM_STRING"), (Throwable)e);
        }
        catch (IOException e) {
            throw new XmlParseException(Messages.getInstance().getErrorString("XmlDom4JHelper.ERROR_0002_UNSUPPORTED_ENCODING"), (Throwable)e);
        }
        return document;
    }

    public static Document getDocFromFile(File file, EntityResolver resolver) throws DocumentException, IOException {
        SAXReader reader = XMLParserFactoryProducer.getSAXReader(resolver);
        return reader.read(file);
    }

    public static Document getDocFromStream(InputStream inStream, EntityResolver resolver) throws DocumentException, IOException {
        SAXReader reader = XMLParserFactoryProducer.getSAXReader(resolver);
        return reader.read(inStream);
    }

    public static Document getDocFromStream(InputStream inStream) throws DocumentException, IOException {
        return XmlDom4JHelper.getDocFromStream(inStream, null);
    }

    protected static final StringBuffer transformXml(StreamSource xslSrc, StreamSource docSrc, Map params, URIResolver resolver) throws TransformerConfigurationException, TransformerException {
        StringBuffer sb = null;
        StringWriter writer = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        if (null != resolver) {
            tf.setURIResolver(resolver);
        }
        Transformer t = tf.newTransformer(xslSrc);
        if (params != null) {
            Set keys = params.keySet();
            for (String key : keys) {
                String val = (String)params.get(key);
                if (val == null) continue;
                t.setParameter(key, val);
            }
        }
        t.transform(docSrc, new StreamResult(writer));
        sb = writer.getBuffer();
        return sb;
    }

    public static final StringBuffer docToString(org.w3c.dom.Document doc) throws TransformerConfigurationException, TransformerException {
        StringBuffer sb = null;
        StringWriter writer = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        DOMSource docSrc = new DOMSource(doc);
        t.transform(docSrc, new StreamResult(writer));
        sb = writer.getBuffer();
        return sb;
    }

    public static String getXmlEncodedString(String rawValue) {
        StringBuffer value = new StringBuffer();
        for (int n = 0; n < rawValue.length(); ++n) {
            char charValue = rawValue.charAt(n);
            if (charValue >= '\u0080') {
                value.append("&#x");
                value.append(Integer.toString(charValue, 16));
                value.append(";");
                continue;
            }
            value.append(charValue);
        }
        return value.toString();
    }

    public static void saveDom(Document doc, OutputStream outputStream, String encoding) throws IOException {
        XmlDom4JHelper.saveDom(doc, outputStream, encoding, false);
    }

    public static void saveDom(Document doc, OutputStream outputStream, String encoding, boolean suppressDeclaration) throws IOException {
        XmlDom4JHelper.saveDom(doc, outputStream, encoding, suppressDeclaration, false);
    }

    public static void saveDom(Document doc, OutputStream outputStream, String encoding, boolean suppressDeclaration, boolean prettyPrint) throws IOException {
        OutputFormat format = prettyPrint ? OutputFormat.createPrettyPrint() : OutputFormat.createCompactFormat();
        format.setSuppressDeclaration(suppressDeclaration);
        if (encoding != null) {
            format.setEncoding(encoding.toLowerCase());
            if (!suppressDeclaration) {
                doc.setXMLEncoding(encoding.toUpperCase());
            }
        }
        XMLWriter writer = new XMLWriter(outputStream, format);
        writer.write(doc);
        writer.flush();
    }

    protected static void closeInputStream(InputStream strm) {
        if (null != strm) {
            try {
                strm.close();
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to close InputStream.", (Throwable)e);
            }
        }
    }

    public static String getNodeText(String xpath, Node rootNode) {
        return XmlDom4JHelper.getNodeText(xpath, rootNode, null);
    }

    public static long getNodeText(String xpath, Node rootNode, long defaultValue) {
        String valueStr = XmlDom4JHelper.getNodeText(xpath, rootNode, Long.toString(defaultValue));
        try {
            return Long.parseLong(valueStr);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static double getNodeText(String xpath, Node rootNode, double defaultValue) {
        String valueStr = XmlDom4JHelper.getNodeText(xpath, rootNode, null);
        if (valueStr == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(valueStr);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static String getNodeText(String xpath, Node rootNode, String defaultValue) {
        if (rootNode == null) {
            return defaultValue;
        }
        Node node = rootNode.selectSingleNode(xpath);
        if (node == null) {
            return defaultValue;
        }
        return node.getText();
    }

    public static Document convertToDom4JDoc(org.w3c.dom.Document doc) throws TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError, DocumentException {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new StringWriter());
        TransformerFactory.newInstance().newTransformer().transform(source, result);
        String theXML = result.getWriter().toString();
        Document dom4jDoc = null;
        try {
            dom4jDoc = XmlDom4JHelper.getDocFromString(theXML, null);
        }
        catch (XmlParseException e) {
            throw new TransformerFactoryConfigurationError((Exception)((Object)e));
        }
        return dom4jDoc;
    }
}

