/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.util.beans.PropertyNameFormatter;
import org.pentaho.platform.util.beans.ValueGenerator;
import org.pentaho.platform.util.beans.ValueSetErrorCallback;
import org.pentaho.platform.util.messages.Messages;

public class BeanUtil {
    private static final Log logger = LogFactory.getLog(BeanUtil.class);
    private PropertyUtilsBean propUtil = new PropertyUtilsBean();
    private BeanUtilsBean typeConvertingBeanUtil;
    protected Object bean;
    protected ValueSetErrorCallback defaultCallback;

    public void setDefaultCallback(ValueSetErrorCallback defaultCallback) {
        this.defaultCallback = defaultCallback;
    }

    public BeanUtil(Object targetBean) {
        this.bean = targetBean;
        ConvertUtilsBean convertUtil = new ConvertUtilsBean();
        convertUtil.register(true, true, 0);
        this.typeConvertingBeanUtil = new BeanUtilsBean(convertUtil);
        this.setDefaultCallback(new EagerFailingCallback());
    }

    public boolean isReadable(String propertyName) {
        return this.propUtil.isReadable(this.bean, propertyName);
    }

    public Object getValue(String propertyName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format("getting property \"{0}\" from bean \"{1}\"", propertyName, this.bean));
        }
        return this.propUtil.getSimpleProperty(this.bean, propertyName);
    }

    public Class<?> getPropertyType(String propertyName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor desc = this.propUtil.getPropertyDescriptor(this.bean, propertyName);
        return desc.getPropertyType();
    }

    public boolean isWriteable(String propertyName) {
        try {
            return this.propUtil.isWriteable(this.bean, propertyName) || this.propUtil.getResolver().isIndexed(propertyName) && this.propUtil.isReadable(this.bean, propertyName);
        }
        catch (IllegalArgumentException exception) {
            logger.debug((Object)"Exception rose. Return false value", (Throwable)exception);
            return false;
        }
    }

    public void setValue(String propertyName, Object value) throws Exception {
        this.setValue(propertyName, value, this.defaultCallback);
    }

    public void setValue(String propertyName, Object value, ValueSetErrorCallback callback) throws Exception {
        this.setValue(propertyName, value, callback, new PropertyNameFormatter[0]);
    }

    public void setValue(String propertyName, Object value, PropertyNameFormatter ... formatters) throws Exception {
        this.setValue(propertyName, value, this.defaultCallback, formatters);
    }

    public void setValue(String propertyName, Object value, ValueSetErrorCallback callback, PropertyNameFormatter ... formatters) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format("setting property \"{0}\" on bean \"{1}\"", propertyName, this.bean));
        }
        if (value == null) {
            logger.info((Object)MessageFormat.format("value to set is null, skipping setting of \"{0}\" property on bean \"{1}\"", propertyName, this.bean));
            return;
        }
        String origPropertyName = propertyName;
        for (PropertyNameFormatter formatter : formatters) {
            propertyName = formatter.format(propertyName);
        }
        if (this.isWriteable(propertyName)) {
            Object val = value;
            if (value instanceof ValueGenerator) {
                val = ((ValueGenerator)value).getValue(propertyName);
            }
            try {
                this.typeConvertingBeanUtil.copyProperty(this.bean, propertyName, val);
            }
            catch (Exception e) {
                String propertyType = "";
                try {
                    propertyType = this.getPropertyType(propertyName).getName();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                callback.failedToSetValue(this.bean, propertyName, val, propertyType, e);
            }
        } else {
            callback.propertyNotWritable(this.bean, origPropertyName);
        }
    }

    public void setValues(Map<String, Object> propValueMap) throws Exception {
        for (Map.Entry<String, Object> entry : propValueMap.entrySet()) {
            this.setValue(entry.getKey(), entry.getValue());
        }
    }

    public void setValues(Map<String, Object> propValueMap, ValueSetErrorCallback callback) throws Exception {
        for (Map.Entry<String, Object> entry : propValueMap.entrySet()) {
            this.setValue(entry.getKey(), entry.getValue(), callback);
        }
    }

    public void setValues(Map<String, Object> propValueMap, PropertyNameFormatter ... formatters) throws Exception {
        for (Map.Entry<String, Object> entry : propValueMap.entrySet()) {
            this.setValue(entry.getKey(), entry.getValue(), formatters);
        }
    }

    public static class EagerFailingCallback
    implements ValueSetErrorCallback {
        @Override
        public void failedToSetValue(Object bean, String propertyName, Object value, String beanPropertyType, Throwable cause) throws Exception {
            String valueType = value != null ? value.getClass().getName() : "[ClassNameNotAvailable]";
            String beanType = bean != null ? bean.getClass().getName() : "[ClassNameNotAvailable]";
            throw new InvocationTargetException(cause, Messages.getInstance().getErrorString("BeanUtil.ERROR_0001_FAILED_TO_SET_PROPERTY", beanType, propertyName, beanPropertyType, valueType));
        }

        @Override
        public void propertyNotWritable(Object bean, String propertyName) throws Exception {
            String beanType = bean != null ? bean.getClass().getName() : "[ClassNameNotAvailable]";
            throw new IllegalAccessException(Messages.getInstance().getErrorString("BeanUtil.ERROR_0002_NO_METHOD_FOR_PROPERTY", beanType, propertyName));
        }
    }

    public static class FeedbackValueGenerator {
        private Object value;

        public FeedbackValueGenerator(Object value) {
            this.value = value;
        }

        public Object getValueToSet(String name) throws Exception {
            return this.value;
        }
    }
}

