/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class StringUtil {
    private static final String RE_CONTAINS_PARENT_PATH = "(^.*[/\\\\]|^)\\.\\.([/\\\\].*$|$)|(^.*\u0000.*$)";
    private static final Pattern CONTAINS_PARENT_PATH_PATTERN = Pattern.compile("(^.*[/\\\\]|^)\\.\\.([/\\\\].*$|$)|(^.*\u0000.*$)");

    private StringUtil() {
    }

    public static String[] tokenStringToArray(String tokenizedString, String token) {
        if (tokenizedString == null) {
            return null;
        }
        if (token == null) {
            return new String[]{tokenizedString};
        }
        StringTokenizer st = new StringTokenizer(tokenizedString, token);
        ArrayList<String> strList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            strList.add(tok);
        }
        String[] rtnArray = new String[strList.size()];
        return strList.toArray(rtnArray);
    }

    public static boolean doesPathContainParentPathSegment(String path) {
        Matcher m = CONTAINS_PARENT_PATH_PATTERN.matcher(path);
        return m.matches();
    }

    public static void main(String[] args) {
        String[] testStrings;
        for (String testString : testStrings = new String[]{"../bart/maggie.xml", "/bart/..", "/bart/../maggie/homer.xml", "..//bart/maggie.xml", "/bart//..", "/bart//../maggie/homer.xml", "/../", "/..", "../", "..\\bart\\maggie.xml", "\\bart\\..", "\\bart\\..\\maggie\\homer.xml", "I am clean", "/go/not/parent.xml", "\\go\\not\\parent.xml", "..", "should/not..not/match", "..should/not/match.xml", "should/not..", "..."}) {
            boolean matches = StringUtil.doesPathContainParentPathSegment(testString);
            if (matches) {
                System.out.println(testString + " matches.");
                continue;
            }
            System.out.println("--------" + testString + " DOES NOT MATCH.");
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String getMapAsPrettyString(Map map) {
        ByteArrayOutputStream writtenBytes = new ByteArrayOutputStream();
        MapUtils.debugPrint((PrintStream)new PrintStream(writtenBytes), (Object)"Map", (Map)map);
        return writtenBytes.toString();
    }

    public static Map<String, String> trimStringMap(Map<String, String> map) {
        return map == null ? map : map.entrySet().stream().collect(Collectors.toMap(e -> StringUtils.trimToEmpty((String)((String)e.getKey())), e -> StringUtils.trimToEmpty((String)((String)e.getValue()))));
    }

    public static List<String> trimStringList(List<String> list) {
        return list == null ? list : list.stream().map(StringUtils::trimToEmpty).collect(Collectors.toList());
    }

    public static String trimToEmpty(String string) {
        return StringUtils.trimToEmpty((String)string);
    }
}

