/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.component.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.engine.services.solution.PentahoEntityResolver;
import org.pentaho.platform.uifoundation.component.FilterDefinition;
import org.pentaho.platform.uifoundation.component.xml.FilterDefinitionFactory;
import org.pentaho.platform.uifoundation.component.xml.FilterPanelException;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.platform.util.xml.XForm;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class FilterPanel {
    public static final boolean debug = true;
    ArrayList filterList;
    String error;
    String name;
    ILogger logger;

    public FilterPanel(IPentahoSession session, Document document, ILogger logger) throws FilterPanelException {
        this.logger = logger;
        this.filterList = new ArrayList();
        if (document != null) {
            List filterNodes = document.selectNodes("filters/filter");
            for (Element filterNode : filterNodes) {
                FilterDefinition filterDefinition = FilterDefinitionFactory.create(filterNode, session, logger);
                this.filterList.add(filterDefinition);
            }
            if (this.filterList.size() == 0) {
                this.error = Messages.getInstance().getString("FilterPanel.ERROR_0001_NO_FILTERS");
                return;
            }
        }
    }

    public List getFilters() {
        return this.filterList;
    }

    public boolean populate(Map parameterProviders, Map defaultValues) {
        int fail = 0;
        if (this.filterList != null) {
            for (FilterDefinition filterDefinition : this.filterList) {
                if (filterDefinition.populate(parameterProviders, (String[])defaultValues.get(filterDefinition.getName()))) {
                    boolean bl = true;
                    continue;
                }
                ++fail;
            }
        }
        return fail == 0;
    }

    public Document getXForm(String actionUrl) {
        StringBuffer content = new StringBuffer();
        Document document = null;
        String strUuid = UUIDUtil.getUUIDAsString().replaceAll("-", "_");
        content.append("<filters xmlns:xf=\"http://www.w3.org/2002/xforms\"><id>" + strUuid + "</id><title><![CDATA[" + Messages.getInstance().getEncodedString(this.name) + "]]></title><description></description><help></help><action><![CDATA[" + actionUrl + "]]></action>");
        if (this.error != null) {
            content.append("<error>");
            content.append(this.error);
            content.append("</error>");
        } else if (this.filterList == null) {
            content.append("<error>");
            content.append(Messages.getInstance().getString("FilterPanel.ERROR_0003_NO_FILTER_VALUES"));
            content.append("</error>");
        } else {
            try {
                Iterator filtersIterator = this.filterList.iterator();
                StringBuffer xformHeader = new StringBuffer();
                String formName = null;
                while (filtersIterator.hasNext()) {
                    FilterDefinition filterDefinition = (FilterDefinition)filtersIterator.next();
                    String filterName = filterDefinition.getName();
                    if (formName == null) {
                        formName = filterName;
                    }
                    String title = filterDefinition.getTitle();
                    StringBuffer xformBody = new StringBuffer();
                    filterDefinition.getXForm(xformHeader, xformBody);
                    content.append("<filter><name><![CDATA[" + filterName + "]]></name>").append("<title><![CDATA[" + title + "]]></title><control>").append(xformBody).append("</control></filter>");
                }
                XForm.completeXFormHeader(formName, xformHeader);
                content.append(xformHeader);
            }
            catch (Exception e) {
                this.logger.error(Messages.getInstance().getErrorString("FilterPanel.ERROR_0004_COULD_NOT_CREATE_CONTENT"), (Throwable)e);
            }
        }
        content.append("</filters>");
        this.logger.debug(content.toString());
        try {
            document = XmlDom4JHelper.getDocFromString(content.toString(), new PentahoEntityResolver());
        }
        catch (XmlParseException e) {
            this.logger.error(Messages.getInstance().getErrorString("FilterPanel.ERROR_0004_COULD_NOT_CREATE_CONTENT"), (Throwable)e);
        }
        return document;
    }
}

