/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.pentaho.commons.connection.DataUtilities;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.PentahoDataTransmuter;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.uifoundation.chart.ChartDefinition;
import org.pentaho.platform.uifoundation.chart.JFreeChartEngine;
import org.pentaho.platform.uifoundation.chart.WidgetDefinition;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public class DialWidgetDefinition
extends WidgetDefinition
implements ChartDefinition {
    private static final long serialVersionUID = 2232742163326878608L;
    private final ArrayList intervals = new ArrayList();
    private final RectangleEdge titlePosition = RectangleEdge.TOP;
    private Paint chartBackgroundPaint = Color.WHITE;
    private Paint plotBackgroundPaint = Color.GRAY;
    private Paint needlePaint = Color.blue;
    private DialShape dialShape = DialShape.CHORD;
    private Font titleFont;
    private final List subTitles = new ArrayList();
    private boolean rangeLimited;
    private int tickSize = 5;
    private Paint tickPaint = Color.blue;
    private Paint valuePaint = Color.BLUE;
    private Font valueFont;
    private String units;
    private Font legendFont = null;
    private boolean legendBorderVisible = true;
    private RectangleEdge legendPosition = RectangleEdge.BOTTOM;
    private Node attributes = null;
    private Float backgroundAlpha;
    private Float foregroundAlpha;

    public DialWidgetDefinition(double value, double minimum, double maximum, boolean rangeLimited) {
        super(value, minimum, maximum);
        this.rangeLimited = rangeLimited;
    }

    public DialWidgetDefinition(IPentahoResultSet data, boolean byRow, Node chartAttributes, int width, int height, IPentahoSession session) {
        this(0.0, Double.MIN_VALUE, Double.MAX_VALUE, false);
        this.attributes = chartAttributes;
        if (data != null) {
            if (byRow) {
                this.setDataByRow(data);
            } else {
                this.setDataByColumn(data);
            }
        }
        this.setLegendFont(chartAttributes.selectSingleNode("legend-font"));
        this.setLegendBorderVisible(chartAttributes.selectSingleNode("legend-border-visible"));
        Node backgroundAlphaNode = chartAttributes.selectSingleNode("background-alpha");
        Node foregroundAlphaNode = chartAttributes.selectSingleNode("foreground-alpha");
        if (backgroundAlphaNode != null) {
            this.setBackgroundAlpha(chartAttributes.selectSingleNode("background-alpha"));
        }
        if (foregroundAlphaNode != null) {
            this.setForegroundAlpha(chartAttributes.selectSingleNode("foreground-alpha"));
        }
        DialWidgetDefinition.createDial(this, chartAttributes, width, height, session);
    }

    public DialWidgetDefinition(Document document, double value, int width, int height, IPentahoSession session) {
        this(value, Double.MIN_VALUE, Double.MAX_VALUE, false);
        this.attributes = document.selectSingleNode("//dial");
        this.deriveMinMax(value);
        DialWidgetDefinition.createDial(this, this.attributes, width, height, session);
    }

    public static Log getLogger() {
        return LogFactory.getLog(DialWidgetDefinition.class);
    }

    public static void createDial(DialWidgetDefinition widgetDefinition, Node dialNode, int width, int height, IPentahoSession session) {
        List subtitles;
        List intervals;
        Node valueFontNode;
        Node tmpNode;
        String backgroundType;
        Element backgroundNode;
        Paint paint;
        Node node = dialNode.selectSingleNode("units");
        if (node != null) {
            String units = node.getText();
            widgetDefinition.setUnits(units);
        }
        if ((paint = JFreeChartEngine.getPaint(dialNode.selectSingleNode("background-color"))) == null) {
            backgroundNode = (Element)dialNode.selectSingleNode("chart-background");
            if (backgroundNode != null) {
                backgroundType = backgroundNode.attributeValue("type");
                if ("texture".equals(backgroundType)) {
                    paint = JFreeChartEngine.getTexturePaint((Node)backgroundNode, width, height, session);
                } else if ("gradient".equals(backgroundType)) {
                    paint = JFreeChartEngine.getGradientPaint((Node)backgroundNode, width, height);
                }
            }
        } else {
            DialWidgetDefinition.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_DEPRECATED_PROPERTY", "background-color", "chart-background"));
            DialWidgetDefinition.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_PROPERTY_WILL_NOT_VALIDATE", "background-color"));
        }
        if (paint != null) {
            widgetDefinition.setChartBackgroundPaint(paint);
        }
        if ((paint = JFreeChartEngine.getPaint(dialNode.selectSingleNode("plot-background-color"))) == null) {
            backgroundNode = (Element)dialNode.selectSingleNode("plot-background");
            if (backgroundNode != null) {
                backgroundType = backgroundNode.attributeValue("type");
                if ("texture".equals(backgroundType)) {
                    paint = JFreeChartEngine.getTexturePaint((Node)backgroundNode, width, height, session);
                } else if ("gradient".equals(backgroundType)) {
                    paint = JFreeChartEngine.getGradientPaint((Node)backgroundNode, width, height);
                }
            }
        } else {
            DialWidgetDefinition.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_DEPRECATED_PROPERTY", "plot-background-color", "plot-background"));
            DialWidgetDefinition.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_PROPERTY_WILL_NOT_VALIDATE", "plot-background-color"));
        }
        if (paint != null) {
            widgetDefinition.setPlotBackgroundPaint(paint);
        }
        if ((paint = JFreeChartEngine.getPaint(dialNode.selectSingleNode("needle-color"))) != null) {
            widgetDefinition.setNeedlePaint(paint);
        }
        if ((paint = JFreeChartEngine.getPaint(dialNode.selectSingleNode("tick-color"))) != null) {
            widgetDefinition.setTickPaint(paint);
        }
        if ((tmpNode = dialNode.selectSingleNode("tick-interval")) != null) {
            widgetDefinition.setTickSize(Integer.parseInt(dialNode.selectSingleNode("tick-interval").getText()));
        }
        if ((paint = JFreeChartEngine.getPaint(dialNode.selectSingleNode("value-color"))) != null) {
            widgetDefinition.setValuePaint(paint);
        }
        widgetDefinition.setDialShape(DialShape.CHORD);
        Node titleFontNode = dialNode.selectSingleNode("title-font");
        if (titleFontNode != null) {
            String titleFontStr;
            Node fontNode = titleFontNode.selectSingleNode("font");
            if (fontNode != null) {
                titleFontStr = fontNode.getText().trim();
                if (!"".equals(titleFontStr)) {
                    Node titleFontSizeNode = titleFontNode.selectSingleNode("size");
                    int size = titleFontSizeNode != null ? Integer.parseInt(titleFontSizeNode.getText()) : 12;
                    widgetDefinition.setTitleFont(new Font(titleFontStr, 1, size));
                }
            } else {
                titleFontStr = titleFontNode.getText().trim();
                if (!"".equals(titleFontStr)) {
                    widgetDefinition.setTitleFont(new Font(titleFontStr, 2, 24));
                }
            }
        }
        if ((valueFontNode = dialNode.selectSingleNode("domain-tick-font")) != null) {
            String fontStr;
            Node fontNode = valueFontNode.selectSingleNode("font");
            if (fontNode != null) {
                fontStr = fontNode.getText().trim();
                if (!"".equals(fontStr)) {
                    Node valueFontSizeNode = valueFontNode.selectSingleNode("size");
                    int size = valueFontSizeNode != null ? Integer.parseInt(valueFontSizeNode.getText()) : 12;
                    widgetDefinition.setValueFont(new Font(fontStr, 1, size));
                }
            } else {
                fontStr = valueFontNode.getText().trim();
                if (!"".equals(fontStr)) {
                    widgetDefinition.setValueFont(new Font(fontStr, 2, 24));
                }
            }
        }
        if ((intervals = dialNode.selectNodes("interval")) == null || intervals.isEmpty()) {
            Node intervalsNode = dialNode.selectSingleNode("intervals");
            if (intervalsNode != null) {
                intervals = intervalsNode.selectNodes("interval");
            }
        } else {
            DialWidgetDefinition.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_DEPRECATED_CHILD", "interval", "intervals"));
            DialWidgetDefinition.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_PROPERTY_WILL_NOT_VALIDATE", "interval"));
        }
        if (intervals != null) {
            for (Node intervalNode : intervals) {
                Element backgroundNode2;
                String label = intervalNode.selectSingleNode("label").getText();
                double minimum = Double.parseDouble(intervalNode.selectSingleNode("minimum").getText());
                double maximum = Double.parseDouble(intervalNode.selectSingleNode("maximum").getText());
                Range range = new Range(minimum, maximum);
                Paint backgroundPaint = JFreeChartEngine.getPaint(intervalNode.selectSingleNode("color"));
                if (backgroundPaint == null && (backgroundNode2 = (Element)intervalNode.selectSingleNode("interval-background")) != null) {
                    String backgroundType2 = backgroundNode2.attributeValue("type");
                    if ("texture".equals(backgroundType2)) {
                        backgroundPaint = JFreeChartEngine.getTexturePaint((Node)backgroundNode2, width, height, session);
                    } else if ("gradient".equals(backgroundType2)) {
                        backgroundPaint = JFreeChartEngine.getGradientPaint((Node)backgroundNode2, width, height);
                    }
                }
                String textColor = intervalNode.selectSingleNode("text-color").getText();
                BasicStroke outlineStroke = intervalNode.selectSingleNode("stroke-width") != null ? new BasicStroke(Float.parseFloat(intervalNode.selectSingleNode("stroke-width").getText())) : new BasicStroke();
                Paint outlinePaint = JFreeChartEngine.getPaint(textColor);
                MeterInterval interval = new MeterInterval(label, range, outlinePaint, (Stroke)outlineStroke, backgroundPaint);
                widgetDefinition.addInterval(interval);
            }
        }
        if ((subtitles = dialNode.selectNodes("subtitle")) == null || subtitles.isEmpty()) {
            Node subTitlesNode = dialNode.selectSingleNode("subtitles");
            if (subTitlesNode != null) {
                subtitles = subTitlesNode.selectNodes("subtitle");
            }
        } else {
            DialWidgetDefinition.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_DEPRECATED_CHILD", "subtitle", "subtitles"));
            DialWidgetDefinition.getLogger().warn((Object)Messages.getInstance().getString("CHART.WARN_PROPERTY_WILL_NOT_VALIDATE", "subtitle"));
        }
        if (subtitles != null) {
            widgetDefinition.addSubTitles(subtitles);
        }
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String getUnits() {
        return this.units;
    }

    private void setDataByColumn(IPentahoResultSet data) {
        this.setDataByRow(PentahoDataTransmuter.pivot((IPentahoResultSet)data));
    }

    private void setDataByRow(IPentahoResultSet data) {
        if (data == null) {
            this.noDataMessage = Messages.getInstance().getString("CHART.USER_NO_DATA_AVAILABLE");
            return;
        }
        Object[] rowData = data.next();
        List numericRowData = DataUtilities.toNumbers((Object[])rowData, (NumberFormat[])new NumberFormat[]{LocaleHelper.getNumberFormat(), LocaleHelper.getCurrencyFormat()});
        double newValue = ((Number)numericRowData.get(0)).doubleValue();
        if (rowData.length >= 3) {
            this.setMinimum(((Number)numericRowData.get(1)).doubleValue());
            this.setMaximum(((Number)numericRowData.get(2)).doubleValue());
        } else {
            this.deriveMinMax(newValue);
        }
        this.setValue(newValue);
    }

    public void deriveMinMax(double value) {
        double min = 0.0;
        double max = 100.0;
        Node node = this.attributes.selectSingleNode("range-limited");
        this.rangeLimited = node == null || "true".equalsIgnoreCase(node.getText());
        max = 0.1;
        double absValue = Math.abs(value);
        while (max < absValue) {
            if ((max *= 2.0) < absValue) {
                min *= 2.5;
                max *= 2.5;
            }
            if (!(max < absValue)) continue;
            min *= 2.0;
            max *= 2.0;
        }
        min = value > 0.0 ? 0.0 : -max;
        this.setMaximum(max);
        this.setMinimum(min);
    }

    public void addInterval(MeterInterval interval) {
        this.intervals.add(interval);
        Range range = interval.getRange();
        double min = range.getLowerBound();
        double max = range.getUpperBound();
        if (this.rangeLimited && this.intervals.size() == 1) {
            this.setMinimum(min);
            this.setMaximum(max);
        } else {
            if (min < this.getMinimum()) {
                this.setMinimum(min);
            }
            if (max > this.getMaximum()) {
                this.setMaximum(max);
            }
        }
    }

    public void setValue(double value) {
        this.setValue(new Double(value));
        if (this.rangeLimited) {
            if (value < this.getMinimum()) {
                this.setValue(this.getMinimum());
            } else if (value > this.getMaximum()) {
                this.setValue(this.getMaximum());
            }
        } else if (value < this.getMinimum()) {
            this.setMinimum(value);
        } else if (value > this.getMaximum()) {
            this.setMaximum(value);
        }
    }

    @Override
    public Paint getPlotBackgroundPaint() {
        return this.plotBackgroundPaint;
    }

    public void setPlotBackgroundPaint(Paint plotBackgroundPaint) {
        this.plotBackgroundPaint = plotBackgroundPaint;
    }

    public Paint getNeedlePaint() {
        return this.needlePaint;
    }

    public void setNeedlePaint(Paint needlePaint) {
        this.needlePaint = needlePaint;
    }

    public DialShape getDialShape() {
        return this.dialShape;
    }

    @Override
    public Font getTitleFont() {
        if (this.titleFont != null) {
            return this.titleFont;
        }
        return new Font("sans-serif", 0, 14);
    }

    public void setTitleFont(Font tFont) {
        this.titleFont = tFont;
    }

    public void setDialShape(DialShape dialShape) {
        this.dialShape = dialShape;
    }

    public List getIntervals() {
        return this.intervals;
    }

    @Override
    public Paint[] getPaintSequence() {
        return null;
    }

    @Override
    public Image getPlotBackgroundImage() {
        return null;
    }

    @Override
    public List getSubtitles() {
        return this.subTitles;
    }

    public void addSubTitles(List subTitleNodes) {
        if (subTitleNodes != null) {
            Iterator iter = subTitleNodes.iterator();
            while (iter.hasNext()) {
                this.addSubTitle(((Node)iter.next()).getText());
            }
        }
    }

    public void addSubTitle(String subTitle) {
        this.subTitles.add(subTitle);
    }

    @Override
    public Paint getChartBackgroundPaint() {
        return this.chartBackgroundPaint;
    }

    @Override
    public Image getChartBackgroundImage() {
        return null;
    }

    @Override
    public boolean isBorderVisible() {
        return false;
    }

    @Override
    public Paint getBorderPaint() {
        return null;
    }

    @Override
    public RectangleEdge getTitlePosition() {
        return this.titlePosition;
    }

    @Override
    public RectangleEdge getLegendPosition() {
        return this.legendPosition;
    }

    public void setChartBackgroundPaint(Paint chartBackgroundPaint) {
        this.chartBackgroundPaint = chartBackgroundPaint;
    }

    @Override
    public int getHeight() {
        return 200;
    }

    @Override
    public int getWidth() {
        return 200;
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public boolean isLegendIncluded() {
        return false;
    }

    @Override
    public boolean isThreeD() {
        return false;
    }

    public Paint getValuePaint() {
        return this.valuePaint;
    }

    public Paint getTickPaint() {
        return this.tickPaint;
    }

    public int getTickSize() {
        return this.tickSize;
    }

    public void setValuePaint(Paint valuePaint) {
        this.valuePaint = valuePaint;
    }

    public void setTickPaint(Paint tickPaint) {
        this.tickPaint = tickPaint;
    }

    public void setTickSize(int tickSize) {
        this.tickSize = tickSize;
    }

    @Override
    public Font getValueFont() {
        return this.valueFont;
    }

    public void setValueFont(Font valueFont) {
        this.valueFont = valueFont;
    }

    @Override
    public boolean isDisplayLabels() {
        return false;
    }

    @Override
    public Font getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(Font legendFont) {
        this.legendFont = legendFont;
    }

    public void setLegendFont(Node legendFontNode) {
        Font font = JFreeChartEngine.getFont(legendFontNode);
        if (font != null) {
            this.setLegendFont(font);
        }
    }

    public void setLegendBorderVisible(Node legendBorderVisibleNode) {
        if (legendBorderVisibleNode != null) {
            boolean legBorderVisible = new Boolean(legendBorderVisibleNode.getText());
            this.setLegendBorderVisible(legBorderVisible);
        }
    }

    public void setLegendBorderVisible(boolean legendBorderVisible) {
        this.legendBorderVisible = legendBorderVisible;
    }

    @Override
    public boolean isLegendBorderVisible() {
        return this.legendBorderVisible;
    }

    @Override
    public Float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(Node backgroundAlphaNode) {
        if (backgroundAlphaNode != null) {
            Float backgroundAlphaValue;
            this.backgroundAlpha = backgroundAlphaValue = new Float(backgroundAlphaNode.getText());
        }
    }

    @Override
    public Float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(Node foregroundAlphaNode) {
        if (foregroundAlphaNode != null) {
            Float foregroundAlphaValue;
            this.foregroundAlpha = foregroundAlphaValue = new Float(foregroundAlphaNode.getText());
        }
    }
}

