/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.runtime;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IParameterResolver;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.engine.services.PentahoMessenger;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;

public class MapParameterResolver
extends PentahoMessenger
implements IParameterResolver {
    private static final long serialVersionUID = -93516661348245465L;
    Map lookupMap;
    String prefix = null;
    IRuntimeContext runtimecontext = null;

    public MapParameterResolver(Map map, String prefix, IRuntimeContext runtime) {
        this.lookupMap = map;
        this.prefix = prefix;
        this.runtimecontext = runtime;
    }

    @Override
    public Log getLogger() {
        return LogFactory.getLog(MapParameterResolver.class);
    }

    public int resolveParameter(String template, String parameter, Matcher parameterMatcher, int copyStart, StringBuffer results) {
        StringTokenizer tokenizer = new StringTokenizer(parameter, ":");
        if (tokenizer.countTokens() == 2) {
            String parameterPrefix = tokenizer.nextToken();
            String inputName = tokenizer.nextToken();
            if (parameterPrefix.equals(this.prefix)) {
                String parameterValue = TemplateUtil.getSystemInput(inputName, this.runtimecontext);
                if (parameterValue == null && this.lookupMap.containsKey(inputName)) {
                    parameterValue = this.lookupMap.get(inputName);
                }
                if (parameterValue != null) {
                    int start = parameterMatcher.start();
                    int end = parameterMatcher.end();
                    StringBuffer parameterBuffer = new StringBuffer();
                    if (parameterValue instanceof String) {
                        parameterBuffer.append(parameterValue.replaceAll("'", "\\'"));
                    } else if (parameterValue instanceof Object[]) {
                        Object[] pObj;
                        for (Object element : pObj = (Object[])parameterValue) {
                            parameterBuffer.append(parameterBuffer.length() == 0 ? "'" + element + "'" : ",'" + element + "'");
                        }
                    } else if (parameterValue instanceof IPentahoResultSet) {
                        IPentahoResultSet rs = (IPentahoResultSet)parameterValue;
                        IPentahoMetaData md = rs.getMetaData();
                        int columnIdx = -1;
                        columnIdx = md.getColumnCount() == 1 ? 0 : md.getColumnIndex(new String[]{parameter});
                        if (columnIdx < 0) {
                            this.error(Messages.getInstance().getErrorString("Template.ERROR_0005_COULD_NOT_DETERMINE_COLUMN"));
                            return -1;
                        }
                        int rowCount = rs.getRowCount();
                        Object valueCell = null;
                        for (int i = 0; i < rowCount; ++i) {
                            valueCell = rs.getValueAt(i, columnIdx);
                            parameterBuffer.append(parameterBuffer.length() == 0 ? "'" + valueCell + "'" : ",'" + valueCell + "'");
                        }
                    } else if (parameterValue instanceof List) {
                        List pObj = (List)((Object)parameterValue);
                        for (int i = 0; i < pObj.size(); ++i) {
                            parameterBuffer.append(parameterBuffer.length() == 0 ? "'" + pObj.get(i) + "'" : ",'" + pObj.get(i) + "'");
                        }
                    } else {
                        parameterBuffer.append(parameterValue.toString().replaceAll("'", "\\'"));
                    }
                    results.append(template.substring(copyStart, start));
                    copyStart = end;
                    results.append(parameterBuffer);
                    return copyStart;
                }
            }
        }
        return -1;
    }
}

