/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.actionsequence;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.io.FilenameUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.commons.connection.memory.MemoryResultSet;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IConditionalExecution;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.ISequenceDefinition;
import org.pentaho.platform.api.engine.ISolutionActionDefinition;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.ActionDefinition;
import org.pentaho.platform.engine.services.actionsequence.ActionParameter;
import org.pentaho.platform.engine.services.actionsequence.ActionParameterSource;
import org.pentaho.platform.engine.services.actionsequence.ActionSequence;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class SequenceDefinition
implements ISequenceDefinition {
    private static final boolean debug = true;
    private int errorCode;
    private String xactionPath;
    private String version;
    private String title;
    private boolean isWebService;
    private String cacheLevel;
    private int loggingLevel;
    private String description;
    private String author;
    private String help;
    private String resultType;
    private String iconPath;
    private Map outputDefinitions;
    private Map inputDefinitions;
    private Map resourceDefinitions;
    IApplicationContext applicationContext;
    ISolutionActionDefinition[] actionDefinitions;

    public static IActionSequence ActionSequenceFactory(Document document, String solutionPath, ILogger logger, IApplicationContext applicationContext, int loggingLevel) {
        Node sequenceDefinitionNode = document.selectSingleNode("//action-sequence");
        if (sequenceDefinitionNode == null) {
            logger.error(Messages.getInstance().getErrorString("SequenceDefinition.ERROR_0002_NO_ACTION_SEQUENCE_NODE", "", solutionPath, ""));
            return null;
        }
        SequenceDefinition seqDef = new SequenceDefinition(sequenceDefinitionNode, solutionPath, logger, applicationContext);
        Node actionNode = sequenceDefinitionNode.selectSingleNode("actions");
        return SequenceDefinition.getNextLoopGroup(seqDef, actionNode, solutionPath, logger, loggingLevel);
    }

    private static IActionSequence getNextLoopGroup(ISequenceDefinition seqDef, Node actionsNode, String solutionPath, ILogger logger, int loggingLevel) {
        String loopParameterName = XmlDom4JHelper.getNodeText("@loop-on", actionsNode);
        boolean loopUsingPeek = "true".equalsIgnoreCase(XmlDom4JHelper.getNodeText("@peek-only", actionsNode));
        ArrayList<Object> actionDefinitionList = new ArrayList<Object>();
        List nodeList = actionsNode.selectNodes("*");
        for (Node actionDefinitionNode : nodeList) {
            if (actionDefinitionNode.getName().equals("actions")) {
                actionDefinitionList.add(SequenceDefinition.getNextLoopGroup(seqDef, actionDefinitionNode, solutionPath, logger, loggingLevel));
                continue;
            }
            if (!actionDefinitionNode.getName().equals("action-definition")) continue;
            ActionDefinition actionDefinition = new ActionDefinition(actionDefinitionNode, logger);
            actionDefinition.setLoggingLevel(loggingLevel);
            actionDefinitionList.add(actionDefinition);
        }
        IConditionalExecution conditionalExecution = SequenceDefinition.parseConditionalExecution(actionsNode, logger, "condition");
        ActionSequence sequence = new ActionSequence(loopParameterName, seqDef, actionDefinitionList, loopUsingPeek);
        sequence.setConditionalExecution(conditionalExecution);
        return sequence;
    }

    private SequenceDefinition(Node sequenceRootNode, String solutionPath, ILogger logger, IApplicationContext applicationContext) {
        this.xactionPath = solutionPath;
        this.applicationContext = applicationContext;
        this.version = XmlDom4JHelper.getNodeText("version", sequenceRootNode);
        this.title = XmlDom4JHelper.getNodeText("title", sequenceRootNode);
        this.isWebService = "true".equals(XmlDom4JHelper.getNodeText("web-service", sequenceRootNode));
        this.loggingLevel = Logger.getLogLevel(XmlDom4JHelper.getNodeText("logging-level", sequenceRootNode));
        this.description = XmlDom4JHelper.getNodeText("documentation/description", sequenceRootNode);
        this.help = XmlDom4JHelper.getNodeText("documentation/help", sequenceRootNode);
        this.author = XmlDom4JHelper.getNodeText("documentation/author", sequenceRootNode);
        this.resultType = XmlDom4JHelper.getNodeText("documentation/result-type", sequenceRootNode);
        this.iconPath = XmlDom4JHelper.getNodeText("documentation/icon", sequenceRootNode);
        this.inputDefinitions = new ListOrderedMap();
        this.errorCode = SequenceDefinition.parseParameters(sequenceRootNode, logger, "inputs/*", this.inputDefinitions, null, true);
        this.outputDefinitions = new ListOrderedMap();
        this.errorCode = SequenceDefinition.parseParameters(sequenceRootNode, logger, "outputs/*", this.outputDefinitions, null, false);
        if (this.errorCode != 0) {
            logger.info(Messages.getInstance().getString("SequenceDefinition.INFO_OUTPUT_PARAMETERS_NOT_DEFINED"));
        }
        this.errorCode = this.parseResourceDefinitions(sequenceRootNode, logger);
        if (this.errorCode != 0) {
            logger.info(Messages.getInstance().getString("SequenceDefinition.INFO_RESOURCES_PARAMETERS_NOT_DEFINED"));
        }
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isWebService() {
        return this.isWebService;
    }

    public String getCacheLevel() {
        return this.cacheLevel;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    static IConditionalExecution parseConditionalExecution(Node actionRootNode, ILogger logger, String nodePath) {
        try {
            Node condition = actionRootNode.selectSingleNode(nodePath);
            if (condition == null) {
                return null;
            }
            String script = condition.getText();
            IConditionalExecution ce = PentahoSystem.get(IConditionalExecution.class, null);
            ce.setScript(script);
            return ce;
        }
        catch (Exception ex) {
            logger.error(Messages.getInstance().getErrorString("SequenceDefinition.ERROR_0005_PARSING_PARAMETERS"), (Throwable)ex);
            return null;
        }
    }

    static int parseParameters(Node actionRootNode, ILogger logger, String nodePath, Map parameterMap, Map mapTo, boolean inputVar) {
        try {
            List parameters = actionRootNode.selectNodes(nodePath);
            Iterator parametersIterator = parameters.iterator();
            Object defaultValue = null;
            while (parametersIterator.hasNext()) {
                Node parameterNode = (Node)parametersIterator.next();
                String parameterName = parameterNode.getName();
                String parameterType = XmlDom4JHelper.getNodeText("@type", parameterNode);
                if (mapTo != null) {
                    mapTo.put(parameterName, XmlDom4JHelper.getNodeText("@mapping", parameterNode, parameterName));
                }
                defaultValue = SequenceDefinition.getDefaultValue(parameterNode);
                List variableNodes = parameterNode.selectNodes(inputVar ? "sources/*" : "destinations/*");
                Iterator variablesIterator = variableNodes.iterator();
                int variableIdx = 1;
                ArrayList<ActionParameterSource> variables = new ArrayList<ActionParameterSource>();
                while (variablesIterator.hasNext()) {
                    Node variableNode = (Node)variablesIterator.next();
                    try {
                        String variableSource = variableNode.getName();
                        String variableName = variableNode.getText();
                        ActionParameterSource variable = new ActionParameterSource(variableSource, variableName);
                        logger.debug(Messages.getInstance().getString("SequenceDefinition.DEBUG_ADDING_SOURCE_FOR_PARAMETER", variableSource, parameterName));
                        variables.add(variable);
                    }
                    catch (Exception e) {
                        logger.error(Messages.getInstance().getErrorString("SequenceDefinition.ERROR_0004_VARIABLE_SOURCE_NOT_VALID", Integer.toString(variableIdx), parameterName), (Throwable)e);
                    }
                    ++variableIdx;
                }
                if (defaultValue != null) {
                    logger.debug(Messages.getInstance().getString("SequenceDefinition.DEBUG_USING_DEFAULT_VALUE", defaultValue.toString(), parameterName));
                }
                boolean isOutputParameter = Boolean.parseBoolean(XmlDom4JHelper.getNodeText("@is-output-parameter", parameterNode, "true"));
                ActionParameter parameter = new ActionParameter(parameterName, parameterType, null, variables, defaultValue);
                parameter.setOutputParameter(isOutputParameter);
                parameterMap.put(parameterName, parameter);
            }
            return 0;
        }
        catch (Exception e) {
            logger.error(Messages.getInstance().getErrorString("SequenceDefinition.ERROR_0005_PARSING_PARAMETERS"), (Throwable)e);
            return 2;
        }
    }

    private int parseResourceDefinitions(Node actionRootNode, ILogger logger) {
        this.resourceDefinitions = new ListOrderedMap();
        try {
            List resources = actionRootNode.selectNodes("resources/*");
            for (Node resourceNode : resources) {
                Node mimeNode;
                Node typeNode = resourceNode.selectSingleNode("./*");
                if (typeNode == null) continue;
                String resourceName = resourceNode.getName();
                String resourceTypeName = typeNode.getName();
                int resourceType = ActionSequenceResource.getResourceType(resourceTypeName);
                String resourceLocation = XmlDom4JHelper.getNodeText("location", typeNode);
                if (resourceType == 1 || resourceType == 3) {
                    if (resourceLocation == null) {
                        logger.error(Messages.getInstance().getErrorString("SequenceDefinition.ERROR_0008_RESOURCE_NO_LOCATION", resourceName));
                        continue;
                    }
                } else if (resourceType == 5) {
                    resourceLocation = XmlDom4JHelper.getNodeText("string", resourceNode);
                } else if (resourceType == 6) {
                    Node xmlNode = typeNode.selectSingleNode("./location/*");
                    String string = resourceLocation = xmlNode == null ? "" : xmlNode.asXML();
                }
                if ((mimeNode = typeNode.selectSingleNode("mime-type")) != null) {
                    String resourceMimeType = mimeNode.getText();
                    if (!(resourceType != 1 && resourceType != 3 || (resourceLocation = FilenameUtils.separatorsToUnix((String)resourceLocation)).startsWith("/"))) {
                        String parentDir = FilenameUtils.getFullPathNoEndSeparator((String)this.xactionPath);
                        if (parentDir.length() == 0) {
                            parentDir = "/";
                        }
                        resourceLocation = FilenameUtils.separatorsToUnix((String)FilenameUtils.concat((String)parentDir, (String)resourceLocation));
                    }
                    ActionSequenceResource resource = new ActionSequenceResource(resourceName, resourceType, resourceMimeType, resourceLocation);
                    this.resourceDefinitions.put(resourceName, resource);
                    continue;
                }
                logger.error(Messages.getInstance().getErrorString("SequenceDefinition.ERROR_0007_RESOURCE_NO_MIME_TYPE", resourceName));
            }
            return 0;
        }
        catch (Exception e) {
            logger.error(Messages.getInstance().getErrorString("SequenceDefinition.ERROR_0006_PARSING_RESOURCE"), (Throwable)e);
            return 2;
        }
    }

    static int parseActionResourceDefinitions(Node actionRootNode, ILogger logger, String nodePath, Map mapTo) {
        try {
            List resources = actionRootNode.selectNodes(nodePath);
            for (Node resourceNode : resources) {
                String resourceName = resourceNode.getName();
                if (mapTo == null) continue;
                mapTo.put(resourceName, XmlDom4JHelper.getNodeText("@mapping", resourceNode, resourceName));
            }
            return 0;
        }
        catch (Exception e) {
            logger.error(Messages.getInstance().getErrorString("SequenceDefinition.ERROR_0006_PARSING_RESOURCE"), (Throwable)e);
            return 2;
        }
    }

    private static Object getDefaultValue(Node parameterNode) {
        Node rootNode = parameterNode.selectSingleNode("default-value");
        if (rootNode == null) {
            return null;
        }
        String dataType = XmlDom4JHelper.getNodeText("@type", rootNode);
        if (dataType == null) {
            dataType = XmlDom4JHelper.getNodeText("@type", parameterNode);
        }
        if ("string-list".equals(dataType)) {
            List nodes = rootNode.selectNodes("list-item");
            if (nodes == null) {
                return null;
            }
            ArrayList<String> rtnList = new ArrayList<String>();
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                rtnList.add(((Node)it.next()).getText());
            }
            return rtnList;
        }
        if ("property-map-list".equals(dataType)) {
            List nodes = rootNode.selectNodes("property-map");
            if (nodes == null) {
                return null;
            }
            ArrayList<Map> rtnList = new ArrayList<Map>();
            for (Node mapNode : nodes) {
                rtnList.add(SequenceDefinition.getMapFromNode(mapNode));
            }
            return rtnList;
        }
        if ("property-map".equals(dataType)) {
            return SequenceDefinition.getMapFromNode(rootNode.selectSingleNode("property-map"));
        }
        if ("long".equals(dataType)) {
            try {
                return new Long(rootNode.getText());
            }
            catch (Exception exception) {
                return null;
            }
        }
        if ("result-set".equals(dataType)) {
            return MemoryResultSet.createFromActionSequenceInputsNode((Node)parameterNode);
        }
        return rootNode.getText();
    }

    private static Map getMapFromNode(Node mapNode) {
        List nodes;
        ListOrderedMap rtnMap = new ListOrderedMap();
        if (mapNode != null && (nodes = mapNode.selectNodes("entry")) != null) {
            for (Node entryNode : nodes) {
                rtnMap.put(XmlDom4JHelper.getNodeText("@key", entryNode), entryNode.getText());
            }
        }
        return rtnMap;
    }

    public Map getInputDefinitions() {
        return this.inputDefinitions;
    }

    public Map getInputDefinitionsForParameterProvider(String parameterProviderName) {
        ListOrderedMap rtnMap = new ListOrderedMap();
        Map paramList = this.getInputDefinitions();
        for (IActionParameter actionParameter : paramList.values()) {
            List vars = actionParameter.getVariables();
            for (int i = 0; i < vars.size(); ++i) {
                ActionParameterSource source = (ActionParameterSource)vars.get(i);
                if (!source.getSourceName().equals(parameterProviderName)) continue;
                rtnMap.put(source.getValue(), actionParameter);
            }
        }
        return rtnMap;
    }

    public Map getOutputDefinitions() {
        return this.outputDefinitions;
    }

    public Map getResourceDefinitions() {
        return this.resourceDefinitions;
    }

    public String getSequenceName() {
        return FilenameUtils.getName((String)this.xactionPath);
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    public String getResultType() {
        return this.resultType;
    }

    public String getHelp() {
        return this.help;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSolutionName() {
        return "";
    }

    public String getSolutionPath() {
        return this.xactionPath;
    }

    public int getLoggingLevel() {
        return this.loggingLevel;
    }

    public String getIcon() {
        return this.iconPath;
    }
}

