/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.security.messages.Messages;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.aop.ThrowsAdvice;

public class LoggingInterceptor
implements MethodBeforeAdvice,
AfterReturningAdvice,
ThrowsAdvice {
    public void before(Method method, Object[] args, Object target) throws Throwable {
        Log logger = LogFactory.getLog(target.getClass());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Messages.getInstance().getString("LoggingInterceptor.DEBUG_BEGIN_METHOD"));
            this.log(method, args, target);
        }
    }

    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) throws Throwable {
        Log logger = LogFactory.getLog(target.getClass());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Messages.getInstance().getString("LoggingInterceptor.DEBUG_END_METHOD"));
            this.log(method, args, target);
            logger.debug((Object)Messages.getInstance().getString("LoggingInterceptor.DEBUG_RETURN_VALUE", returnValue.getClass().getName(), this.toString(returnValue)));
        }
    }

    public void afterThrowing(Method method, Object[] args, Object target, Throwable exception) {
        Log logger = LogFactory.getLog(target.getClass());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Messages.getInstance().getString("LoggingInterceptor.DEBUG_EXCEPTION_IN_METHOD"));
            this.log(method, args, target);
            logger.debug((Object)Messages.getInstance().getString("LoggingInterceptor.DEBUG_EXCEPTION", exception.getClass().getName(), exception.getMessage()));
            logger.debug((Object)Messages.getInstance().getString("LoggingInterceptor.DEBUG_STACK_TRACE"), exception);
        }
    }

    private void log(Method method, Object[] args, Object target) {
        Log logger = LogFactory.getLog(target.getClass());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Messages.getInstance().getString("LoggingInterceptor.DEBUG_METHOD_NAME", method.getName()));
            logger.debug((Object)Messages.getInstance().getString("LoggingInterceptor.DEBUG_TARGET_OBJECT", target.getClass().getName(), this.toString(target)));
            logger.debug((Object)Messages.getInstance().getString("LoggingInterceptor.DEBUG_METHOD_ARGS", this.arrayToString(args)));
        }
    }

    protected String toString(Object object) {
        return new ReflectionToStringBuilder(object){

            protected boolean accept(Field f) {
                return super.accept(f) && !f.getName().equals("password") && !f.getName().equals("credentials");
            }
        }.toString();
    }

    protected String arrayToString(Object[] objects) {
        StringBuffer buf = new StringBuffer();
        if (null == objects) {
            return "null";
        }
        for (int i = 0; i < objects.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.toString(objects[i]));
        }
        return buf.toString();
    }
}

