/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac.spring;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.ListUtils;
import org.pentaho.platform.engine.core.system.objfac.spring.BarrierBean;
import org.pentaho.platform.servicecoordination.api.IServiceBarrier;
import org.pentaho.platform.servicecoordination.api.IServiceBarrierManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarrierBeanProcessor {
    private Logger logger = LoggerFactory.getLogger(BarrierBeanProcessor.class);
    private static BarrierBeanProcessor barrierBeanProcessor;
    private IServiceBarrierManager serviceBarrierManager = IServiceBarrierManager.LOCATOR.getManager();
    private Map<String, List<BarrierBean>> barrierBeans = new ConcurrentHashMap<String, List<BarrierBean>>();
    private Map<String, Set<String>> beanBarriers = new ConcurrentHashMap<String, Set<String>>();

    private BarrierBeanProcessor() {
    }

    public static BarrierBeanProcessor getInstance() {
        if (barrierBeanProcessor == null) {
            barrierBeanProcessor = new BarrierBeanProcessor();
        }
        return barrierBeanProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBarrierBeans(String barrierBeanFilePath) {
        Properties barrierBeanProperties = new Properties();
        File barrierBeanFile = new File(barrierBeanFilePath);
        if (barrierBeanFile.exists()) {
            FileInputStream fileInput = null;
            try {
                fileInput = new FileInputStream(barrierBeanFile);
                barrierBeanProperties.load(fileInput);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fileInput != null) {
                    try {
                        fileInput.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.registerBarrierBeans(barrierBeanProperties);
        }
    }

    public void registerBarrierBeans(Properties barrierBeanProperties) {
        Enumeration<Object> enuKeys = barrierBeanProperties.keys();
        while (enuKeys.hasMoreElements()) {
            String barrierName = (String)enuKeys.nextElement();
            IServiceBarrier barrier = this.serviceBarrierManager.getServiceBarrier(barrierName);
            List theseBarrierBeans = BarrierBean.convertString(barrierBeanProperties.getProperty(barrierName));
            if (theseBarrierBeans.size() <= 0) continue;
            for (BarrierBean barrierBean : theseBarrierBeans) {
                if (this.beanBarriers.containsKey(barrierBean.getBeanName())) {
                    this.beanBarriers.get(barrierBean.getBeanName()).add(barrierName);
                    continue;
                }
                HashSet<String> newSet = new HashSet<String>();
                newSet.add(barrierName);
                this.beanBarriers.put(barrierBean.getBeanName(), newSet);
            }
            List<BarrierBean> finalBarrierBeans = this.barrierBeans.get(barrierName);
            finalBarrierBeans = finalBarrierBeans == null ? theseBarrierBeans : ListUtils.union(finalBarrierBeans, theseBarrierBeans);
            this.barrierBeans.put(barrierName, finalBarrierBeans);
        }
    }

    public Map<String, List<BarrierBean>> getBarrierBeans() {
        return this.barrierBeans;
    }

    public Map<String, Set<String>> getBeanBarriers() {
        return this.beanBarriers;
    }

    public void awaitBarrier(String barrierName) {
        try {
            this.serviceBarrierManager.getServiceBarrier(barrierName).awaitAvailability();
        }
        catch (InterruptedException e1) {
            this.logger.error("ServiceBarrier Interrupted", (Throwable)e1);
        }
    }
}

