/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.system.osgi.OSGIUtils;
import org.pentaho.platform.engine.core.system.osgi.OsgiPentahoObjectReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGIObjectFactory
implements IPentahoObjectFactory {
    private BundleContext context;
    Logger log = LoggerFactory.getLogger(OSGIObjectFactory.class);
    public static final String REFERENCE_CLASS = "reference_class";

    public OSGIObjectFactory(BundleContext context) {
        this.context = context;
    }

    public <T> T get(Class<T> tClass, IPentahoSession session) throws ObjectFactoryException {
        return this.get(tClass, null, session);
    }

    public <T> T get(Class<T> interfaceClass, String key, IPentahoSession session) throws ObjectFactoryException {
        Map<String, String> map = key != null ? Collections.singletonMap("id", key) : Collections.emptyMap();
        return this.get(interfaceClass, session, map);
    }

    public <T> T get(Class<T> interfaceClass, IPentahoSession session, Map<String, String> properties) throws ObjectFactoryException {
        if (!this.isBundleContextValid()) {
            return null;
        }
        try {
            HashMap<String, String> props = new HashMap<String, String>();
            if (properties != null) {
                props.putAll(properties);
            }
            props.put(REFERENCE_CLASS, interfaceClass.getName());
            Collection serviceReferences = this.context.getServiceReferences(IPentahoObjectReference.class, OSGIUtils.createFilter(props));
            if (serviceReferences != null && serviceReferences.size() > 0) {
                IPentahoObjectReference obj = (IPentahoObjectReference)this.context.getService((ServiceReference)serviceReferences.iterator().next());
                return (T)obj.getObject();
            }
        }
        catch (InvalidSyntaxException e) {
            this.log.debug("Error retrieving from OSGI as ServiceReference, will try as bare type", (Throwable)e);
        }
        String filter = OSGIUtils.createFilter(properties);
        try {
            Collection refs = this.context.getServiceReferences(interfaceClass, filter);
            ServiceReference ref = refs != null && refs.size() > 0 ? refs.toArray(new ServiceReference[refs.size()])[0] : this.context.getServiceReference("" + interfaceClass.getName());
            if (ref == null) {
                this.log.info("\n\nOSGI: did not find object: " + interfaceClass.getName());
                return null;
            }
            Object obj = this.context.getService(ref);
            if (obj instanceof IPentahoInitializer) {
                ((IPentahoInitializer)obj).init(session);
            }
            return (T)obj;
        }
        catch (InvalidSyntaxException e) {
            this.log.error("Error retrieving from OSGI ObjectFactory", (Throwable)e);
            return null;
        }
    }

    public boolean objectDefined(String clazz) {
        if (clazz == null) {
            throw new IllegalStateException("Class is null");
        }
        if (!this.isBundleContextValid()) {
            return false;
        }
        ServiceReference ref = this.context.getServiceReference(clazz);
        return ref != null;
    }

    public boolean objectDefined(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalStateException("Class is null");
        }
        try {
            return this.getObjectReference(clazz, null) != null;
        }
        catch (ObjectFactoryException e) {
            return false;
        }
    }

    public Class<?> getImplementingClass(String key) {
        throw new UnsupportedOperationException("OSGI Object Factory does not support this method");
    }

    public void init(String configFile, Object context) {
    }

    public <T> List<T> getAll(Class<T> interfaceClass, IPentahoSession curSession) throws ObjectFactoryException {
        return this.getAll(interfaceClass, curSession, Collections.emptyMap());
    }

    public <T> List<T> getAll(Class<T> interfaceClass, IPentahoSession session, Map<String, String> properties) throws ObjectFactoryException {
        if (!this.isBundleContextValid()) {
            return null;
        }
        ArrayList<Object> returnList = new ArrayList<Object>();
        if (properties == null || !properties.containsKey(REFERENCE_CLASS)) {
            HashMap<String, String> props = new HashMap<String, String>();
            if (properties != null) {
                props.putAll(properties);
            }
            props.put(REFERENCE_CLASS, interfaceClass.getName());
            List<IPentahoObjectReference> all = this.getAll(IPentahoObjectReference.class, session, props);
            if (all != null) {
                for (IPentahoObjectReference iPentahoObjectReference : all) {
                    returnList.add(iPentahoObjectReference.getObject());
                }
            }
        }
        String filter = OSGIUtils.createFilter(properties);
        try {
            Collection refs = this.context.getServiceReferences(interfaceClass, filter);
            if (refs == null || refs.size() == 0) {
                this.log.info("\n\nOSGI: did not find object: " + interfaceClass.getName());
                return returnList;
            }
            for (ServiceReference ref : refs) {
                Object obj = this.context.getService(ref);
                if (obj instanceof IPentahoInitializer) {
                    ((IPentahoInitializer)obj).init(session);
                }
                returnList.add(obj);
            }
            return returnList;
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return returnList;
        }
    }

    public <T> IPentahoObjectReference<T> getObjectReference(Class<T> interfaceClass, IPentahoSession curSession) throws ObjectFactoryException {
        return this.getObjectReference(interfaceClass, curSession, Collections.emptyMap());
    }

    public <T> IPentahoObjectReference<T> getObjectReference(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        if (!this.isBundleContextValid()) {
            return null;
        }
        if (properties == null || !properties.containsKey(REFERENCE_CLASS)) {
            HashMap<String, String> props = new HashMap<String, String>();
            if (properties != null) {
                props.putAll(properties);
            }
            props.put(REFERENCE_CLASS, interfaceClass.getName());
            IPentahoObjectReference<IPentahoObjectReference> objectReference = this.getObjectReference(IPentahoObjectReference.class, curSession, props);
            if (objectReference != null) {
                return (IPentahoObjectReference)objectReference.getObject();
            }
        }
        String filter = OSGIUtils.createFilter(properties);
        try {
            Collection refs = this.context.getServiceReferences(interfaceClass, filter);
            if (refs == null || refs.size() == 0) {
                this.log.info("\n\nOSGI: did not find object: " + interfaceClass.getName());
                return null;
            }
            ServiceReference[] serviceReferences = refs.toArray(new ServiceReference[refs.size()]);
            Arrays.sort(serviceReferences, new Comparator<ServiceReference>(){

                @Override
                public int compare(ServiceReference o1, ServiceReference o2) {
                    Object oRank1 = o1.getProperty("service.ranking");
                    Object oRank2 = o2.getProperty("service.ranking");
                    int rank1 = oRank1 != null && oRank1 instanceof Integer ? (Integer)oRank1 : 0;
                    int rank2 = oRank2 != null && oRank2 instanceof Integer ? (Integer)oRank2 : 0;
                    return rank1 - rank2;
                }
            });
            ServiceReference serviceReference = serviceReferences[0];
            return new OsgiPentahoObjectReference<T>(this.context, interfaceClass, serviceReference);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> List<IPentahoObjectReference<T>> getObjectReferences(Class<T> interfaceClass, IPentahoSession curSession) throws ObjectFactoryException {
        return this.getObjectReferences(interfaceClass, curSession, Collections.emptyMap());
    }

    public <T> List<IPentahoObjectReference<T>> getObjectReferences(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        if (!this.isBundleContextValid()) {
            return Collections.emptyList();
        }
        ArrayList<IPentahoObjectReference<T>> returnRefs = new ArrayList<IPentahoObjectReference<T>>();
        if (properties == null || !properties.containsKey(REFERENCE_CLASS)) {
            HashMap<String, String> props = new HashMap<String, String>();
            if (properties != null) {
                props.putAll(properties);
            }
            props.put(REFERENCE_CLASS, interfaceClass.getName());
            List<IPentahoObjectReference<IPentahoObjectReference>> objectReferences = this.getObjectReferences(IPentahoObjectReference.class, curSession, props);
            for (IPentahoObjectReference iPentahoObjectReference : objectReferences) {
                returnRefs.add((IPentahoObjectReference<T>)iPentahoObjectReference.getObject());
            }
        }
        String filter = OSGIUtils.createFilter(properties);
        try {
            Collection refs = this.context.getServiceReferences(interfaceClass, filter);
            if (refs == null || refs.size() == 0) {
                this.log.info("OSGI: did not find object: " + interfaceClass.getName());
                return returnRefs;
            }
            for (ServiceReference serviceReference : refs) {
                returnRefs.add(new OsgiPentahoObjectReference<T>(this.context, interfaceClass, serviceReference));
            }
            Collections.sort(returnRefs);
            return returnRefs;
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    private boolean isBundleContextValid() {
        try {
            int state = this.context.getBundle().getState();
            switch (state) {
                case 32: {
                    return true;
                }
            }
            return false;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }
}

