/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.output;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IContentOutputHandler;
import org.pentaho.platform.api.engine.IMimeTypeListener;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.output.SimpleContentItem;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class SimpleOutputHandler
implements IOutputHandler {
    private IContentItem feedbackContent;
    boolean allowFeedback;
    private String mimeType;
    private int outputType = 3;
    private boolean contentGenerated;
    private Map<String, IContentItem> outputs;
    private IPentahoSession session;
    private IMimeTypeListener mimeTypeListener;
    private boolean responseExpected;
    private static final Log logger = LogFactory.getLog(SimpleOutputHandler.class);

    public SimpleOutputHandler(IContentItem contentItem, boolean allowFeedback) {
        this.contentGenerated = false;
        this.outputs = new HashMap<String, IContentItem>();
        try {
            String key = "response.content";
            this.outputs.put(key, contentItem);
            this.allowFeedback = allowFeedback;
            if (allowFeedback) {
                this.feedbackContent = new SimpleContentItem(contentItem.getOutputStream(null));
            }
        }
        catch (IOException ioe) {
            logger.error(null, (Throwable)ioe);
        }
    }

    public SimpleOutputHandler(OutputStream outputStream, boolean allowFeedback) {
        this.allowFeedback = allowFeedback;
        if (allowFeedback) {
            this.feedbackContent = new SimpleContentItem(outputStream);
        }
        this.contentGenerated = false;
        this.outputs = new HashMap<String, IContentItem>();
        this.setOutputStream(outputStream, "response", "content");
    }

    public void setSession(IPentahoSession session) {
        this.session = session;
    }

    public IPentahoSession getSession() {
        return this.session;
    }

    public void setOutputStream(OutputStream outputStream, String outputName, String contentName) {
        String key = outputName + "." + contentName;
        SimpleContentItem item = new SimpleContentItem(outputStream);
        this.outputs.put(key, item);
    }

    public void setOutputPreference(int outputType) {
        this.outputType = outputType;
    }

    public boolean contentDone() {
        return this.contentGenerated;
    }

    public int getOutputPreference() {
        return this.outputType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean allowFeedback() {
        return this.allowFeedback;
    }

    public IContentItem getFeedbackContentItem() {
        if (this.allowFeedback) {
            this.contentGenerated = true;
            this.responseExpected = true;
            return this.feedbackContent;
        }
        return null;
    }

    public IContentItem getOutputContentItem(String outputName, String contentName, String instanceId, String localMimeType) {
        String key;
        if (outputName.equals("response") && contentName.equals("content")) {
            this.responseExpected = true;
        }
        if (this.outputs.get(key = outputName + "." + contentName) != null) {
            return this.outputs.get(key);
        }
        IContentOutputHandler output = PentahoSystem.getOutputDestinationFromContentRef(contentName, this.session);
        if (output == null) {
            output = PentahoSystem.getOutputDestinationFromContentRef(outputName + ":" + contentName, this.session);
        }
        if (output != null) {
            output.setInstanceId(instanceId);
            output.setMimeType(localMimeType);
            output.setContentRef(contentName);
            if (contentName.indexOf(":") != -1) {
                output.setSolutionPath(contentName.substring(contentName.indexOf(":") + 1));
            } else {
                output.setSolutionPath(null);
            }
            return output.getFileOutputContentItem();
        }
        return null;
    }

    public void setContentItem(IContentItem content, String objectName, String contentName) {
        this.mimeType = content.getMimeType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutput(String name, Object value) throws IOException {
        IContentItem response;
        if (value == null) {
            logger.info((Object)Messages.getInstance().getString("SimpleOutputHandler.INFO_VALUE_IS_NULL"));
            return;
        }
        if ("content".equalsIgnoreCase(name) && (response = this.getOutputContentItem("response", "content", null, null)) != null) {
            if (value instanceof IContentItem) {
                IContentItem content = (IContentItem)value;
                InputStream inStr = content.getInputStream();
                if (inStr != null) {
                    if (response.getMimeType() == null || !response.getMimeType().equalsIgnoreCase(content.getMimeType())) {
                        response.setMimeType(content.getMimeType());
                    }
                    try {
                        OutputStream outStr = response.getOutputStream(null);
                        int inCnt = 0;
                        byte[] buf = new byte[4096];
                        while (-1 != (inCnt = inStr.read(buf))) {
                            outStr.write(buf, 0, inCnt);
                        }
                    }
                    finally {
                        try {
                            inStr.close();
                        }
                        catch (Exception exception) {}
                    }
                    this.contentGenerated = true;
                }
            } else {
                if (response.getMimeType() == null) {
                    response.setMimeType("text/html");
                }
                response.getOutputStream(null).write(value.toString().getBytes());
                this.contentGenerated = true;
            }
        }
    }

    public IMimeTypeListener getMimeTypeListener() {
        return this.mimeTypeListener;
    }

    public void setMimeTypeListener(IMimeTypeListener mimeTypeListener) {
        this.mimeTypeListener = mimeTypeListener;
    }

    public boolean isResponseExpected() {
        return this.responseExpected;
    }
}

