/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.valuemapper;

import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.valuemapper.ValueMapperMeta;
import org.pentaho.metaverse.api.ChangeType;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.model.Operation;

public class ValueMapperStepAnalyzer
extends StepAnalyzer<ValueMapperMeta> {
    protected void customAnalyze(ValueMapperMeta meta, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
        rootNode.setProperty("defaultValue", (Object)meta.getNonMatchDefault());
    }

    public Set<ComponentDerivationRecord> getChangeRecords(ValueMapperMeta valueMapperMeta) throws MetaverseAnalyzerException {
        String fieldToUse = valueMapperMeta.getFieldToUse();
        String targetField = valueMapperMeta.getTargetField() == null ? fieldToUse : valueMapperMeta.getTargetField();
        String[] sourceValues = valueMapperMeta.getSourceValue();
        String[] targetValues = valueMapperMeta.getTargetValue();
        HashSet<ComponentDerivationRecord> changeRecords = new HashSet<ComponentDerivationRecord>(1);
        ComponentDerivationRecord changeRecord = new ComponentDerivationRecord(fieldToUse, targetField, ChangeType.DATA);
        for (int i = 0; i < sourceValues.length; ++i) {
            String mapping = sourceValues[i] + " -> " + targetValues[i];
            changeRecord.addOperation(new Operation("mapping", ChangeType.DATA, "transforms", mapping));
        }
        changeRecords.add(changeRecord);
        return changeRecords;
    }

    protected Set<StepField> getUsedFields(ValueMapperMeta meta) {
        HashSet<StepField> usedFields = new HashSet<StepField>();
        usedFields.addAll(this.createStepFields(meta.getFieldToUse(), this.getInputs()));
        return usedFields;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        return new HashSet<Class<? extends BaseStepMeta>>(){
            {
                this.add(ValueMapperMeta.class);
            }
        };
    }
}

