/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.jms;

import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSContext;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.serialization.Sensitive;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.jms.JmsConstants;
import org.pentaho.di.trans.step.jms.context.JmsProvider;

public class JmsDelegate {
    @Injection(name="DESTINATION")
    public String destinationName = "";
    @Injection(name="IBMMQ_URL")
    public String ibmUrl = "";
    @Injection(name="IBMMQ_USERNAME")
    public String ibmUsername = "";
    @Sensitive
    @Injection(name="IBMMQ_PASSWORD")
    public String ibmPassword = "";
    @Injection(name="AMQ_URL")
    public String amqUrl = "";
    @Injection(name="AMQ_USERNAME")
    public String amqUsername = "";
    @Sensitive
    @Injection(name="AMQ_PASSWORD")
    public String amqPassword = "";
    @Injection(name="CONNECTION_TYPE")
    public String connectionType = JmsProvider.ConnectionType.ACTIVEMQ.name();
    @Injection(name="DESTINATION_TYPE")
    public String destinationType = JmsProvider.DestinationType.QUEUE.name();
    @Injection(name="RECEIVE_TIMEOUT")
    public String receiveTimeout = "0";
    @Injection(name="MESSAGE_FIELD_NAME")
    public String messageField = "message";
    @Injection(name="DESTINATION_FIELD_NAME")
    public String destinationField = "destination";
    @Injection(name="SSL_ENABLED", group="SSL_GROUP")
    public boolean sslEnabled = false;
    @Injection(name="SSL_KEYSTORE_PATH", group="SSL_GROUP")
    public String sslKeystorePath = "";
    @Injection(name="SSL_KEYSTORE_TYPE", group="SSL_GROUP")
    public String sslKeystoreType = "";
    @Sensitive
    @Injection(name="SSL_KEYSTORE_PASSWORD", group="SSL_GROUP")
    public String sslKeystorePassword = "";
    @Injection(name="SSL_TRUSTSTORE_PATH", group="SSL_GROUP")
    public String sslTruststorePath = "";
    @Injection(name="SSL_TRUSTSTORE_TYPE", group="SSL_GROUP")
    public String sslTruststoreType = "";
    @Sensitive
    @Injection(name="SSL_TRUSTSTORE_PASSWORD", group="SSL_GROUP")
    public String sslTruststorePassword = "";
    @Injection(name="SSL_CONTEXT_ALGORITHM", group="SSL_GROUP")
    public String sslContextAlgorithm = "";
    @Injection(name="SSL_CIPHERSUITE", group="SSL_GROUP")
    public String sslCipherSuite = "";
    @Injection(name="IBM_SSL_FIPSREQUIRED", group="SSL_GROUP")
    public String ibmSslFipsRequired = "";
    @Injection(name="AMQ_SSL_PROVIDER", group="SSL_GROUP")
    public String amqSslProvider = "";
    @Injection(name="AMQ_SSL_VERIFY_HOST", group="SSL_GROUP")
    public String amqSslVerifyHost = "";
    @Injection(name="AMQ_SSL_TRUST_ALL", group="SSL_GROUP")
    public String amqSslTrustAll = "";
    private final List<JmsProvider> jmsProviders;

    public JmsDelegate(List<JmsProvider> jmsProviders) {
        this.jmsProviders = jmsProviders;
    }

    public JmsDelegate(JmsDelegate orig) {
        this.jmsProviders = orig.jmsProviders;
        this.destinationName = orig.destinationName;
        this.ibmUrl = orig.ibmUrl;
        this.ibmUsername = orig.ibmUsername;
        this.ibmPassword = orig.ibmPassword;
        this.amqUrl = orig.amqUrl;
        this.amqUsername = orig.amqUsername;
        this.amqPassword = orig.amqPassword;
        this.connectionType = orig.connectionType;
        this.destinationType = orig.destinationType;
        this.receiveTimeout = orig.receiveTimeout;
        this.messageField = orig.messageField;
        this.destinationField = orig.destinationField;
        this.sslEnabled = orig.sslEnabled;
        this.sslKeystorePath = orig.sslKeystorePath;
        this.sslKeystoreType = orig.sslKeystoreType;
        this.sslKeystorePassword = orig.sslKeystorePassword;
        this.sslTruststorePath = orig.sslTruststorePath;
        this.sslTruststoreType = orig.sslTruststoreType;
        this.sslTruststorePassword = orig.sslTruststorePassword;
        this.sslContextAlgorithm = orig.sslContextAlgorithm;
        this.sslCipherSuite = orig.sslCipherSuite;
        this.ibmSslFipsRequired = orig.ibmSslFipsRequired;
        this.amqSslProvider = orig.amqSslProvider;
        this.amqSslVerifyHost = orig.amqSslVerifyHost;
        this.amqSslTrustAll = orig.amqSslTrustAll;
    }

    Destination getDestination() {
        return this.getJmsProvider().getDestination(this);
    }

    JMSContext getJmsContext() {
        return this.getJmsProvider().getContext(this);
    }

    JmsProvider getJmsProvider() {
        return this.jmsProviders.stream().filter(prov -> prov.supports(JmsProvider.ConnectionType.valueOf(this.connectionType))).findFirst().orElseThrow(() -> new RuntimeException(BaseMessages.getString((Class)JmsConstants.PKG, (String)"JmsDelegate.UnsupportedConnectionType", (String[])new String[0])));
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public String getConnectionUrl() {
        return this.connectionType.equals((Object)JmsProvider.ConnectionType.ACTIVEMQ) ? this.amqUrl : this.ibmUrl;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public String getReceiveTimeout() {
        return this.receiveTimeout;
    }

    RowMetaInterface getRowMeta() {
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(this.messageField));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(this.destinationField));
        return rowMeta;
    }
}

