/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.tree;

import com.tonbeller.wcf.changeorder.ChangeOrderModel;
import com.tonbeller.wcf.changeorder.ChangeOrderUtils;
import com.tonbeller.wcf.tree.DecoratedTreeModel;
import com.tonbeller.wcf.tree.MutableTreeModel;
import com.tonbeller.wcf.tree.TreeModel;
import com.tonbeller.wcf.tree.TreeModelChangeEvent;
import com.tonbeller.wcf.tree.TreeModelChangeListener;
import com.tonbeller.wcf.tree.TreeModelChangeSupport;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class MutableTreeModelDecorator
implements DecoratedTreeModel,
MutableTreeModel,
ChangeOrderModel {
    TreeModel decoree;
    Object[] roots;
    Object[] noChildren = new Object[0];
    Map childrenMap;
    Map parentMap;
    boolean enableChangeOrder = true;
    TreeModelChangeSupport changeSupport;
    private TreeModelChangeListener changeListener = new TreeModelChangeListener(){

        public void treeModelChanged(TreeModelChangeEvent event) {
            MutableTreeModelDecorator.this.childrenMap.clear();
            MutableTreeModelDecorator.this.parentMap.clear();
            MutableTreeModelDecorator.this.roots = null;
            MutableTreeModelDecorator.this.changeSupport.fireModelChanged(event);
        }
    };

    public MutableTreeModelDecorator(TreeModel decoree) {
        this.childrenMap = new HashMap();
        this.parentMap = new HashMap();
        this.changeSupport = new TreeModelChangeSupport(this);
        this.setDecoree(decoree);
    }

    public MutableTreeModelDecorator(TreeModel decoree, Comparator comp) {
        this.childrenMap = new TreeMap(comp);
        this.parentMap = new TreeMap(comp);
        this.changeSupport = new TreeModelChangeSupport(this);
        this.setDecoree(decoree);
    }

    public void setDecoree(TreeModel newDecoree) {
        if (this.decoree != null) {
            this.decoree.removeTreeModelChangeListener(this.changeListener);
        }
        this.decoree = newDecoree;
        this.decoree.addTreeModelChangeListener(this.changeListener);
    }

    public TreeModel getDecoree() {
        return this.decoree;
    }

    public void change(Object parent, Object[] children) {
        if (children == null) {
            children = this.noChildren;
        }
        this.childrenMap.put(parent, children);
        for (int i = 0; i < children.length; ++i) {
            this.parentMap.put(children[i], parent);
        }
        this.changeSupport.fireModelChanged(false, parent);
    }

    public Object[] getRoots() {
        if (this.roots == null) {
            this.roots = this.decoree.getRoots();
        }
        return this.roots;
    }

    public boolean hasChildren(Object node) {
        Object value = this.childrenMap.get(node);
        if (value == null) {
            boolean hasChildren = this.decoree.hasChildren(node);
            if (hasChildren) {
                return true;
            }
            this.childrenMap.put(node, this.noChildren);
            return false;
        }
        return value != this.noChildren;
    }

    public Object[] getChildren(Object node) {
        Object[] children = (Object[])this.childrenMap.get(node);
        if (children == null) {
            children = this.decoree.getChildren(node);
            this.change(node, children);
        }
        return children;
    }

    public Object getParent(Object node) {
        Object parent = this.parentMap.get(node);
        if (parent != null) {
            return parent;
        }
        return this.decoree.getParent(node);
    }

    int indexOf(Object obj, Object[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public boolean mayMove(Object scope, Object node) {
        return this.enableChangeOrder;
    }

    public void move(Object scope, Object node, int oldIndex, int newIndex) {
        Object parent = this.getParent(node);
        Object[] children = parent == null ? this.getRoots() : this.getChildren(parent);
        ChangeOrderUtils.move(children, oldIndex, newIndex);
        this.change(parent, children);
    }

    public boolean isEnableChangeOrder() {
        return this.enableChangeOrder;
    }

    public void setEnableChangeOrder(boolean enableChangeOrder) {
        this.enableChangeOrder = enableChangeOrder;
    }

    public void fireModelChanged(boolean identityChanged) {
        this.changeSupport.fireModelChanged(identityChanged);
    }

    public void addTreeModelChangeListener(TreeModelChangeListener l) {
        this.changeSupport.addTreeModelChangeListener(l);
    }

    public void removeTreeModelChangeListener(TreeModelChangeListener l) {
        this.changeSupport.removeTreeModelChangeListener(l);
    }
}

