/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.param;

import com.tonbeller.wcf.expr.ExprUtils;
import com.tonbeller.wcf.param.SessionParam;
import com.tonbeller.wcf.param.SessionParamPool;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;

public class SetParamTagBase
extends TagSupport {
    String displayName;
    String displayValue;
    String paramName;
    String sqlValue;
    String mdxValue;
    String textValue;
    private static final Logger logger = Logger.getLogger((Class)SetParamTagBase.class);
    SessionParam oldParam;
    SessionParam newParam;

    public int doStartTag() throws JspException {
        SessionParamPool pool = SessionParamPool.instance(this.pageContext);
        this.oldParam = pool.getParam(this.paramName);
        try {
            if (this.oldParam == null) {
                this.newParam = new SessionParam();
                this.newParam.setName(this.paramName);
            } else {
                this.newParam = (SessionParam)this.oldParam.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            logger.error(null, (Throwable)e);
            throw new JspException((Throwable)e);
        }
        this.initialize(this.newParam);
        pool.setParam(this.newParam);
        return 1;
    }

    protected void initialize(SessionParam p) {
        if (this.displayName != null) {
            p.setDisplayName(this.evalStr(this.displayName));
        }
        if (this.displayValue != null) {
            p.setDisplayValue(this.evalStr(this.displayValue));
        }
        if (this.paramName != null) {
            p.setName(this.evalStr(this.paramName));
        }
        if (this.sqlValue != null) {
            p.setSqlValue(this.evalObj(this.sqlValue));
        }
        if (this.mdxValue != null) {
            p.setMdxValue(this.evalStr(this.mdxValue));
        }
        if (this.textValue != null) {
            p.setMdxValue(this.evalStr(this.mdxValue));
        }
    }

    protected Object evalObj(String s) {
        if (ExprUtils.isExpression(s)) {
            return ExprUtils.getModelReference(this.pageContext, s);
        }
        return s;
    }

    protected String evalStr(String s) {
        if (ExprUtils.isExpression(s)) {
            return String.valueOf(ExprUtils.getModelReference(this.pageContext, s));
        }
        return s;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    public void setMdxValue(String mdxValue) {
        this.mdxValue = mdxValue;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public void setSqlValue(String sqlExpr) {
        this.sqlValue = sqlExpr;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }
}

