/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.format;

import com.tonbeller.wcf.format.FormatHandler;
import com.tonbeller.wcf.format.Pattern;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public abstract class FormatHandlerSupport
implements FormatHandler {
    protected String name;
    protected String pattern;
    protected String errorMessage;
    protected ArrayList patterns = new ArrayList();
    protected Locale locale;

    public void addPattern(Pattern p) {
        this.patterns.add(p);
    }

    protected String findPattern(String userPattern) {
        if (userPattern != null && userPattern.length() > 0) {
            return userPattern;
        }
        Iterator it = this.patterns.iterator();
        while (it.hasNext()) {
            Pattern p = (Pattern)it.next();
            if (!this.locale.getLanguage().equals(p.getLanguage())) continue;
            return p.getPattern();
        }
        return this.getPattern();
    }

    protected String getErrorMessage(String userInput) {
        String errorMessage = null;
        Iterator it = this.patterns.iterator();
        while (it.hasNext()) {
            Pattern p = (Pattern)it.next();
            if (!this.locale.getLanguage().equals(p.getLanguage())) continue;
            errorMessage = p.getErrorMessage();
        }
        if (errorMessage == null) {
            errorMessage = this.getErrorMessage();
        }
        if (errorMessage == null) {
            return userInput;
        }
        return MessageFormat.format(errorMessage, userInput);
    }

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

