/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.form;

import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.ComponentSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.form.FormDocument;
import com.tonbeller.wcf.utils.DomUtils;
import com.tonbeller.wcf.utils.SoftException;
import org.apache.log4j.Logger;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ConfirmComponent
extends ComponentSupport {
    Document document;
    Element title;
    Element body;
    RequestListener acceptHandler;
    RequestListener cancelHandler;
    public static final String SESSIONKEY = "confirmForm";
    public static final String BUNDLE = "com.tonbeller.wcf.form.resources";
    private static final Logger logger = Logger.getLogger((Class)ConfirmComponent.class);

    public static ConfirmComponent instance() {
        return (ConfirmComponent)RequestContext.instance().getSession().getAttribute(SESSIONKEY);
    }

    public void initialize(RequestContext context) throws Exception {
        super.initialize(context);
        FormDocument.replaceI18n(context, this.document, BUNDLE);
    }

    public ConfirmComponent(String id, Component parent, Document document) {
        super(id, parent);
        this.document = document;
        try {
            this.title = (Element)new DOMXPath("//title").selectSingleNode((Object)document);
            this.body = (Element)new DOMXPath("//td[@id='body']").selectSingleNode((Object)document);
        }
        catch (JaxenException e) {
            logger.error(null, (Throwable)e);
            throw new SoftException(e);
        }
        this.getDispatcher().addRequestListener("confirm.accept", null, new RequestListener(){

            public void request(RequestContext context) throws Exception {
                ConfirmComponent.this.setVisible(false);
                if (ConfirmComponent.this.acceptHandler != null) {
                    ConfirmComponent.this.acceptHandler.request(context);
                }
            }
        });
        this.getDispatcher().addRequestListener("confirm.cancel", null, new RequestListener(){

            public void request(RequestContext context) throws Exception {
                ConfirmComponent.this.setVisible(false);
                if (ConfirmComponent.this.cancelHandler != null) {
                    ConfirmComponent.this.cancelHandler.request(context);
                }
            }
        });
        this.setVisible(false);
    }

    public Document render(RequestContext context) throws Exception {
        return this.document;
    }

    public void show(String title, String text, RequestListener accept, RequestListener cancel) {
        DomUtils.removeChildNodesExceptAttributes(this.body);
        this.title.setAttribute("value", title);
        DomUtils.setText(this.body, text);
        this.acceptHandler = accept;
        this.cancelHandler = cancel;
        this.setVisible(true);
    }

    public void show(String title, String text1, String[] list, String text2, RequestListener accept, RequestListener cancel) {
        DomUtils.removeChildNodesExceptAttributes(this.body);
        this.title.setAttribute("value", title);
        Text t1 = this.document.createTextNode(text1);
        this.body.appendChild(t1);
        Element ul = this.document.createElement("ul");
        this.body.appendChild(ul);
        for (int i = 0; i < list.length; ++i) {
            Element li = this.document.createElement("li");
            ul.appendChild(li);
            li.appendChild(this.document.createTextNode(list[i]));
        }
        Text t2 = this.document.createTextNode(text2);
        this.body.appendChild(t2);
        this.acceptHandler = accept;
        this.cancelHandler = cancel;
        this.setVisible(true);
    }

    public void show(String title, String textA, String[] listA, String textB, String[] listB, String text, RequestListener accept, RequestListener cancel) {
        DomUtils.removeChildNodesExceptAttributes(this.body);
        this.title.setAttribute("value", title);
        this.appendGroup(this.document, textA, listA);
        this.appendGroup(this.document, textB, listB);
        Text t = this.document.createTextNode(text);
        this.body.appendChild(t);
        this.acceptHandler = accept;
        this.cancelHandler = cancel;
        this.setVisible(true);
    }

    private void appendGroup(Document doc, String text, String[] list) {
        if (list == null || list.length == 0) {
            return;
        }
        Text t = this.document.createTextNode(text);
        this.body.appendChild(t);
        Element ul = this.document.createElement("ul");
        this.body.appendChild(ul);
        for (int i = 0; i < list.length; ++i) {
            Element li = this.document.createElement("li");
            ul.appendChild(li);
            li.appendChild(this.document.createTextNode(list[i]));
        }
    }
}

