/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.controller;

import com.tonbeller.tbutils.testenv.Environment;
import com.tonbeller.wcf.controller.Controller;
import com.tonbeller.wcf.controller.MultiPartEnabledRequest;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestContextFactoryFinder;
import com.tonbeller.wcf.controller.RequestSynchronizer;
import com.tonbeller.wcf.controller.WcfController;
import com.tonbeller.wcf.utils.DomUtils;
import com.tonbeller.wcf.utils.JDK13Utils;
import com.tonbeller.wcf.utils.UrlUtils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class RequestFilter
implements Filter {
    private static Logger logger = Logger.getLogger((Class)RequestFilter.class);
    static final String NEXTVIEW = RequestFilter.class.getName() + ".nextview";
    static final String ISNEW = RequestFilter.class.getName() + ".isnew";
    public static final String CONTEXT = "context";
    public static final String FORCE_INDEX_JSP = "com.tonbeller.wcf.controller.FORCE_INDEX_JSP";
    public static final String RESET_RANDOM_SEED = "resetRandomSeed";
    private String errorJSP = null;
    private String busyJSP = null;
    private String indexJSP = null;
    private String[] passThru = null;
    private String forceExtension = null;

    public void init(FilterConfig config) throws ServletException {
        this.errorJSP = config.getInitParameter("errorJSP");
        this.forceExtension = config.getInitParameter("forceExtension");
        this.indexJSP = config.getInitParameter("indexJSP");
        this.busyJSP = config.getInitParameter("busyJSP");
        String patternList = config.getInitParameter("passThru");
        this.passThru = UrlUtils.parseUrlPatternList(patternList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        MultiPartEnabledRequest request = new MultiPartEnabledRequest((HttpServletRequest)req);
        HttpServletResponse response = (HttpServletResponse)res;
        HttpSession session = request.getSession(true);
        MDC.put((String)"SessionID", (Object)session.getId());
        String cpath = request.getContextPath();
        request.setAttribute(CONTEXT, cpath);
        RequestContext context = RequestContextFactoryFinder.createContext((HttpServletRequest)request, response, true);
        try {
            Config.set((ServletRequest)request, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)context.getLocale());
            if (logger.isInfoEnabled()) {
                this.logRequest((HttpServletRequest)request);
            }
            if (this.passThru(req)) {
                chain.doFilter(req, res);
                return;
            }
            MyHandler handler = new MyHandler(context, chain);
            long t1 = System.currentTimeMillis();
            handler.normalRequest();
            long t2 = System.currentTimeMillis();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Request Execution total time: " + (t2 - t1) + " ms"));
            }
        }
        catch (Throwable e) {
            PrintWriter out = null;
            try {
                out = response.getWriter();
            }
            catch (Exception e2) {
                out = new PrintWriter(System.out);
                logger.error((Object)"No output writer could be retrieved, logging to stdout");
            }
            out.println("<html><body>");
            while (e != null) {
                logger.error((Object)"Error handling request", e);
                out.println();
                out.println("<h2>" + e.toString() + "</h2><pre>");
                e.printStackTrace(out);
                out.println("</pre>");
                void prev = e;
                if ((e = JDK13Utils.getCause(e)) != prev) continue;
                break;
            }
            out.println("</body></html>");
        }
        finally {
            context.invalidate();
        }
    }

    private boolean passThru(ServletRequest req) {
        if (this.passThru == null) {
            return false;
        }
        HttpServletRequest hsr = (HttpServletRequest)req;
        return UrlUtils.matchPattern(hsr, this.passThru);
    }

    void setForceExtension(String forceExtension) {
        this.forceExtension = forceExtension;
    }

    private void logRequest(HttpServletRequest request) {
        logger.info((Object)(">>> Request " + request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + request.getServletPath() + "[" + request.getPathInfo() + "]" + "[?" + request.getQueryString() + "]"));
    }

    public static void setSessionIsNew(HttpSession session, boolean isNew) {
        session.setAttribute(ISNEW, (Object)Boolean.toString(isNew));
    }

    public static void setForceIndexJsp(HttpSession session, boolean b) {
        if (b) {
            session.setAttribute(FORCE_INDEX_JSP, (Object)"true");
        } else {
            session.removeAttribute(FORCE_INDEX_JSP);
        }
    }

    public void destroy() {
    }

    class MyHandler
    implements RequestSynchronizer.Handler {
        protected RequestContext context;
        protected HttpServletRequest request;
        protected HttpServletResponse response;
        protected FilterChain filterChain;

        public MyHandler(RequestContext context, FilterChain filterChain) {
            this.context = context;
            this.request = context.getRequest();
            this.response = context.getResponse();
            this.filterChain = filterChain;
        }

        public String getResultURI() {
            String uri = (String)this.request.getAttribute(NEXTVIEW);
            if (uri != null) {
                uri = UrlUtils.forceExtension(uri, RequestFilter.this.forceExtension);
                uri = UrlUtils.redirectURI(this.request, uri);
                return uri;
            }
            return this.request.getRequestURI();
        }

        public void normalRequest() throws Exception {
            HttpSession session = this.request.getSession(true);
            try {
                if (this.request.getParameter(RequestFilter.RESET_RANDOM_SEED) != null) {
                    DomUtils.setRandomSeed(123L);
                }
                if (this.redirectToIndex()) {
                    return;
                }
                Controller controller = WcfController.instance(session);
                controller.request(this.context);
                if (this.response.containsHeader("Location")) {
                    return;
                }
                if (this.context.isResponseComplete()) {
                    return;
                }
                String uri = (String)this.request.getAttribute(NEXTVIEW);
                if (session.getAttribute(RequestFilter.FORCE_INDEX_JSP) != null) {
                    session.removeAttribute(RequestFilter.FORCE_INDEX_JSP);
                    uri = RequestFilter.this.indexJSP;
                }
                if (uri != null) {
                    this.forward(uri);
                } else {
                    this.filterChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }

        public void recursiveRequest() throws Exception {
            try {
                this.filterChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }

        private void handleException(Exception e) throws Exception {
            logger.error((Object)"exeption", (Throwable)e);
            logger.error((Object)"cause", JDK13Utils.getCause(e));
            if (this.isErrorPage()) {
                throw e;
            }
            if (RequestFilter.this.errorJSP != null) {
                try {
                    logger.info((Object)("redirecting to error page " + RequestFilter.this.errorJSP));
                    this.request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
                    this.request.getRequestDispatcher(RequestFilter.this.errorJSP).forward((ServletRequest)this.request, (ServletResponse)this.response);
                }
                catch (Exception e2) {
                    throw e;
                }
            } else {
                throw e;
            }
        }

        public void showBusyPage(boolean redirect) throws Exception {
            if (this.redirectToIndex()) {
                return;
            }
            if (RequestFilter.this.busyJSP != null) {
                if (redirect) {
                    this.forward(RequestFilter.this.busyJSP);
                } else {
                    this.filterChain.doFilter((ServletRequest)this.request, (ServletResponse)this.response);
                }
            } else {
                throw new IllegalStateException("concurrent requests and no busy.jsp defined in web.xml");
            }
        }

        public boolean isBusyPage() {
            if (RequestFilter.this.busyJSP == null) {
                return false;
            }
            return this.request.getRequestURI().endsWith(RequestFilter.this.busyJSP);
        }

        public boolean isErrorPage() {
            if (RequestFilter.this.errorJSP == null) {
                return false;
            }
            return this.request.getRequestURI().endsWith(RequestFilter.this.errorJSP);
        }

        private void forward(String uri) throws IOException {
            uri = UrlUtils.redirectURI(this.request, uri);
            uri = UrlUtils.forceExtension(uri, RequestFilter.this.forceExtension);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("redirecting to " + uri));
            }
            this.response.sendRedirect(uri);
        }

        protected boolean redirectToIndex() throws Exception {
            if (RequestFilter.this.indexJSP != null) {
                if (Environment.isTest()) {
                    return false;
                }
                HttpSession session = this.context.getSession();
                boolean isNew = session.isNew();
                if (!isNew) {
                    boolean bl = isNew = !"false".equals(session.getAttribute(ISNEW));
                }
                if (isNew) {
                    session.setAttribute(ISNEW, (Object)"false");
                    this.forward(RequestFilter.this.indexJSP);
                    return true;
                }
            }
            return false;
        }
    }
}

