/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.colorchooser;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.ColorUtility;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ColorSchema;

public class DefaultColorSchema
implements ColorSchema {
    private String name;
    private ArrayList<Color> colors;

    public DefaultColorSchema() {
        this.colors = new ArrayList<Color>(this.colors);
        this.name = "<unnamed>";
    }

    public void load(Configuration p, String prefix) {
        String colorText;
        this.name = p.getConfigProperty(prefix + ".name");
        if (this.name == null) {
            this.name = "<unnamed>";
        }
        this.colors.clear();
        int i = 0;
        while (!StringUtils.isEmpty((String)(colorText = p.getConfigProperty(prefix + ".color." + i)))) {
            try {
                this.colors.add(ColorUtility.toPropertyValue(colorText));
            }
            catch (Exception e) {
                break;
            }
            ++i;
        }
    }

    public void load(Properties p) {
        String colorText;
        this.name = p.getProperty("name");
        if (this.name == null) {
            this.name = "<unnamed>";
        }
        this.colors.clear();
        int i = 0;
        while (!StringUtils.isEmpty((String)(colorText = p.getProperty("color." + i)))) {
            try {
                this.colors.add(ColorUtility.toPropertyValue(colorText));
            }
            catch (Exception e) {
                break;
            }
            ++i;
        }
    }

    public void save(Properties p) {
        p.setProperty("name", this.name);
        Color[] colorsArray = this.getColors();
        for (int i = 0; i < colorsArray.length; ++i) {
            Color color = colorsArray[i];
            p.setProperty("color." + i, ColorUtility.toAttributeValue(color));
        }
    }

    public void add(Color c) {
        this.colors.add(c);
    }

    public void clear() {
        this.colors.clear();
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
    }

    public void setColors(Color[] colors) {
        this.colors.clear();
        this.colors.addAll(Arrays.asList(colors));
    }

    @Override
    public Color[] getColors() {
        return this.colors.toArray(new Color[this.colors.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

