/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.bulk;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import org.pentaho.reporting.libraries.base.util.BulkDataUtility;
import org.pentaho.reporting.libraries.designtime.swing.Messages;
import org.pentaho.reporting.libraries.designtime.swing.bulk.BulkDataProvider;

public class SortBulkUpAction
extends AbstractAction {
    private BulkDataProvider tableModel;
    private ListSelectionModel listSelectionModel;
    private JTable editorTable;

    public SortBulkUpAction(BulkDataProvider tableModel, ListSelectionModel listSelectionModel) {
        if (tableModel == null) {
            throw new NullPointerException();
        }
        if (listSelectionModel == null) {
            throw new NullPointerException();
        }
        this.tableModel = tableModel;
        this.listSelectionModel = listSelectionModel;
        this.putValue("SmallIcon", Messages.getInstance().getIcon("Icons.MOVE_UP"));
        this.putValue("ShortDescription", Messages.getInstance().getString("Action.MOVE_UP"));
    }

    public SortBulkUpAction(BulkDataProvider tableModel, ListSelectionModel listSelectionModel, JTable editorTable) {
        this(tableModel, listSelectionModel);
        this.editorTable = editorTable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        TableCellEditor cellEditor;
        if (this.listSelectionModel.isSelectionEmpty()) {
            return;
        }
        if (this.listSelectionModel.getMinSelectionIndex() == 0) {
            return;
        }
        if (this.editorTable != null && (cellEditor = this.editorTable.getCellEditor()) != null) {
            cellEditor.stopCellEditing();
        }
        Object[] data = this.tableModel.getBulkData();
        Object[] result = (Object[])data.clone();
        boolean[] selections = new boolean[result.length];
        for (i = this.listSelectionModel.getMinSelectionIndex(); i <= this.listSelectionModel.getMaxSelectionIndex(); ++i) {
            selections[i] = this.listSelectionModel.isSelectedIndex(i);
        }
        BulkDataUtility.pushUp((Object[])result, (boolean[])selections);
        this.tableModel.setBulkData(result);
        this.listSelectionModel.setValueIsAdjusting(true);
        this.listSelectionModel.removeSelectionInterval(0, selections.length);
        for (i = 0; i < selections.length; ++i) {
            boolean selection = selections[i];
            if (!selection) continue;
            this.listSelectionModel.addSelectionInterval(i, i);
        }
        this.listSelectionModel.setValueIsAdjusting(false);
    }
}

